/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.klaviyo.operation.getlists;

import com.nodepit.nodes.klaviyo.HttpRequestNodeParameters;
import com.nodepit.nodes.klaviyo.NodeParametersUtils;
import com.nodepit.nodes.klaviyo.ResponseMapper;
import com.nodepit.nodes.klaviyo.SimpleResponseMapper;
import com.nodepit.nodes.klaviyo.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class GetListsNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Set Fields[flow]", description="Enable to set the optional field <b>Fields[flow]</b>")
    @ValueReference(value=FieldsFlowEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean fieldsFlowEnabled = false;
    @Widget(title="Fields[flow]", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FieldsFlowEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Fields_FlowPersistor.class)
    Fields_Flow[] fieldsFlow = new Fields_Flow[]{new Fields_Flow(FIELDS_FLOW_VALUES[0])};
    private static final String[] FIELDS_FLOW_VALUES = new String[]{"name", "status", "archived", "created", "updated", "trigger_type"};
    @Widget(title="Set Fields[list]", description="Enable to set the optional field <b>Fields[list]</b>")
    @ValueReference(value=FieldsListEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean fieldsListEnabled = false;
    @Widget(title="Fields[list]", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FieldsListEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Fields_ListPersistor.class)
    Fields_List[] fieldsList = new Fields_List[]{new Fields_List(FIELDS_LIST_VALUES[0])};
    private static final String[] FIELDS_LIST_VALUES = new String[]{"name", "created", "updated", "opt_in_process"};
    @Widget(title="Set Fields[tag]", description="Enable to set the optional field <b>Fields[tag]</b>")
    @ValueReference(value=FieldsTagEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean fieldsTagEnabled = false;
    @Widget(title="Fields[tag]", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FieldsTagEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Fields_TagPersistor.class)
    Fields_Tag[] fieldsTag = new Fields_Tag[]{new Fields_Tag(FIELDS_TAG_VALUES[0])};
    private static final String[] FIELDS_TAG_VALUES = new String[]{"name"};
    @Widget(title="Set Filter", description="Enable to set the optional field <b>Filter</b>")
    @ValueReference(value=FilterEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean filterEnabled = false;
    @Widget(title="Filter", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#filtering<br/>Allowed field(s)/operator(s):<br/><tt>name</tt>: <tt>any</tt>, <tt>equals</tt><br/><tt>id</tt>: <tt>any</tt>, <tt>equals</tt><br/><tt>created</tt>: <tt>greater-than</tt><br/><tt>updated</tt>: <tt>greater-than</tt>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FilterEnabledRef.class, type=Effect.EffectType.SHOW)
    String filter = null;
    @Widget(title="Set Include", description="Enable to set the optional field <b>Include</b>")
    @ValueReference(value=IncludeEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean includeEnabled = false;
    @Widget(title="Include", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=IncludeEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=IncludePersistor.class)
    Include[] include = new Include[]{new Include(INCLUDE_VALUES[0])};
    private static final String[] INCLUDE_VALUES = new String[]{"flow-triggers", "tags"};
    @Widget(title="Set Page[cursor]", description="Enable to set the optional field <b>Page[cursor]</b>")
    @ValueReference(value=PageCursorEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean pageCursorEnabled = false;
    @Widget(title="Page[cursor]", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#pagination\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=PageCursorEnabledRef.class, type=Effect.EffectType.SHOW)
    String pageCursor = null;
    @Widget(title="Set Sort", description="Enable to set the optional field <b>Sort</b>")
    @ValueReference(value=SortEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean sortEnabled = false;
    @Widget(title="Sort", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sorting\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=SortEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=SortChoicesProvider.class)
    String sort = SORT_VALUES[0];
    private static final String[] SORT_VALUES = new String[]{"created", "-created", "id", "-id", "name", "-name", "updated", "-updated"};
    @Widget(title="Revision", description="API endpoint revision (format: YYYY-MM-DD[.suffix])\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String revision = "2025-07-15";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Type:</b> </li>\n\t<li><b>Id:</b> Primary key that uniquely identifies this list. Generated by Klaviyo.</li>\n\t<li><b>Attributes:</b> </li>\n\t<li><b>Links:</b> </li>\n\t<li><b>Relationships:</b> </li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetListsNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"data\":{\"*\":{\"type\":\"rows[#2][0]\",\"id\":\"rows[#2][1]\",\"attributes\":\"rows[#2][2]\",\"links\":\"rows[#2][3]\",\"relationships\":\"rows[#2][4]\"}}}}]").addBodyColumn(new DataColumnSpecCreator("Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Attributes", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Links", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Relationships", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    GetListsNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.revision == null || this.revision.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cRevision\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/vnd.api+json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.fieldsFlowEnabled) {
            Arrays.stream(this.fieldsFlow).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("fields[flow]", value.text));
            });
        }
        if (this.fieldsListEnabled) {
            Arrays.stream(this.fieldsList).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("fields[list]", value.text));
            });
        }
        if (this.fieldsTagEnabled) {
            Arrays.stream(this.fieldsTag).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("fields[tag]", value.text));
            });
        }
        if (this.filterEnabled) {
            params.add(new HttpRequestNodeParameters.Param("filter", this.filter));
        }
        if (this.includeEnabled) {
            Arrays.stream(this.include).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("include", value.text));
            });
        }
        if (this.pageCursorEnabled) {
            params.add(new HttpRequestNodeParameters.Param("page[cursor]", this.pageCursor));
        }
        if (this.sortEnabled) {
            params.add(new HttpRequestNodeParameters.Param("sort", this.sort));
        }
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getHeaderParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("revision", this.revision));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class FieldsFlowEnabledRef
    implements BooleanReference {
        private FieldsFlowEnabledRef() {
        }
    }

    private static final class FieldsListEnabledRef
    implements BooleanReference {
        private FieldsListEnabledRef() {
        }
    }

    private static final class FieldsTagEnabledRef
    implements BooleanReference {
        private FieldsTagEnabledRef() {
        }
    }

    static final class Fields_Flow
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=Fields_FlowChoicesProvider.class)
        String text;

        Fields_Flow() {
        }

        Fields_Flow(String text) {
            this.text = text;
        }

        private static final class Fields_FlowChoicesProvider
        implements StringChoicesProvider {
            private Fields_FlowChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(FIELDS_FLOW_VALUES);
            }
        }
    }

    private static final class Fields_FlowPersistor
    implements NodeParametersPersistor<Fields_Flow[]> {
        static final String CONFIG_KEY = "fieldsFlow";

        private Fields_FlowPersistor() {
        }

        public Fields_Flow[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Fields_Flow[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Fields_Flow::new).toArray(Fields_Flow[]::new);
        }

        public void save(Fields_Flow[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    static final class Fields_List
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=Fields_ListChoicesProvider.class)
        String text;

        Fields_List() {
        }

        Fields_List(String text) {
            this.text = text;
        }

        private static final class Fields_ListChoicesProvider
        implements StringChoicesProvider {
            private Fields_ListChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(FIELDS_LIST_VALUES);
            }
        }
    }

    private static final class Fields_ListPersistor
    implements NodeParametersPersistor<Fields_List[]> {
        static final String CONFIG_KEY = "fieldsList";

        private Fields_ListPersistor() {
        }

        public Fields_List[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Fields_List[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Fields_List::new).toArray(Fields_List[]::new);
        }

        public void save(Fields_List[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    static final class Fields_Tag
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=Fields_TagChoicesProvider.class)
        String text;

        Fields_Tag() {
        }

        Fields_Tag(String text) {
            this.text = text;
        }

        private static final class Fields_TagChoicesProvider
        implements StringChoicesProvider {
            private Fields_TagChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(FIELDS_TAG_VALUES);
            }
        }
    }

    private static final class Fields_TagPersistor
    implements NodeParametersPersistor<Fields_Tag[]> {
        static final String CONFIG_KEY = "fieldsTag";

        private Fields_TagPersistor() {
        }

        public Fields_Tag[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Fields_Tag[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Fields_Tag::new).toArray(Fields_Tag[]::new);
        }

        public void save(Fields_Tag[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class FilterEnabledRef
    implements BooleanReference {
        private FilterEnabledRef() {
        }
    }

    private static final class GetListsNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetListsNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    static final class Include
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=IncludeChoicesProvider.class)
        String text;

        Include() {
        }

        Include(String text) {
            this.text = text;
        }

        private static final class IncludeChoicesProvider
        implements StringChoicesProvider {
            private IncludeChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(INCLUDE_VALUES);
            }
        }
    }

    private static final class IncludeEnabledRef
    implements BooleanReference {
        private IncludeEnabledRef() {
        }
    }

    private static final class IncludePersistor
    implements NodeParametersPersistor<Include[]> {
        static final String CONFIG_KEY = "include";

        private IncludePersistor() {
        }

        public Include[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Include[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Include::new).toArray(Include[]::new);
        }

        public void save(Include[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class PageCursorEnabledRef
    implements BooleanReference {
        private PageCursorEnabledRef() {
        }
    }

    private static final class SortChoicesProvider
    implements StringChoicesProvider {
        private SortChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(SORT_VALUES);
        }
    }

    private static final class SortEnabledRef
    implements BooleanReference {
        private SortEnabledRef() {
        }
    }
}

