/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.klaviyo.operation.getpropertiesformetric;

import com.nodepit.nodes.klaviyo.HttpRequestNodeParameters;
import com.nodepit.nodes.klaviyo.NodeParametersUtils;
import com.nodepit.nodes.klaviyo.ResponseMapper;
import com.nodepit.nodes.klaviyo.SimpleResponseMapper;
import com.nodepit.nodes.klaviyo.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class GetPropertiesForMetricNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Id", description="The ID of the metric\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String id = null;
    @Widget(title="Set Additional Fields[metric Property]", description="Enable to set the optional field <b>Additional Fields[metric Property]</b>")
    @ValueReference(value=AdditionalFieldsMetricPropertyEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean additionalFieldsMetricPropertyEnabled = false;
    @Widget(title="Additional Fields[metric Property]", description="Request additional fields not included by default in the response. Supported values: 'sample_values'\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=AdditionalFieldsMetricPropertyEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Additional_Fields_Metric_PropertyPersistor.class)
    Additional_Fields_Metric_Property[] additionalFieldsMetricProperty = new Additional_Fields_Metric_Property[]{new Additional_Fields_Metric_Property(ADDITIONAL_FIELDS_METRIC_PROPERTY_VALUES[0])};
    private static final String[] ADDITIONAL_FIELDS_METRIC_PROPERTY_VALUES = new String[]{"sample_values"};
    @Widget(title="Set Fields[metric Property]", description="Enable to set the optional field <b>Fields[metric Property]</b>")
    @ValueReference(value=FieldsMetricPropertyEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean fieldsMetricPropertyEnabled = false;
    @Widget(title="Fields[metric Property]", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FieldsMetricPropertyEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Fields_Metric_PropertyPersistor.class)
    Fields_Metric_Property[] fieldsMetricProperty = new Fields_Metric_Property[]{new Fields_Metric_Property(FIELDS_METRIC_PROPERTY_VALUES[0])};
    private static final String[] FIELDS_METRIC_PROPERTY_VALUES = new String[]{"label", "property", "inferred_type", "sample_values"};
    @Widget(title="Revision", description="API endpoint revision (format: YYYY-MM-DD[.suffix])\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String revision = "2025-07-15";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Type:</b> </li>\n\t<li><b>Id:</b> The ID of the metric property</li>\n\t<li><b>Attributes:</b> </li>\n\t<li><b>Links:</b> </li>\n\t<li><b>Relationships:</b> </li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetPropertiesForMetricNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"data\":{\"*\":{\"type\":\"rows[#2][0]\",\"id\":\"rows[#2][1]\",\"attributes\":\"rows[#2][2]\",\"links\":\"rows[#2][3]\",\"relationships\":\"rows[#2][4]\"}}}}]").addBodyColumn(new DataColumnSpecCreator("Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Attributes", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Links", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Relationships", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    GetPropertiesForMetricNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.id == null || this.id.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cId\u201d is required.");
        }
        if (this.revision == null || this.revision.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cRevision\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/vnd.api+json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("id", this.id));
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.additionalFieldsMetricPropertyEnabled) {
            Arrays.stream(this.additionalFieldsMetricProperty).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("additional-fields[metric-property]", value.text));
            });
        }
        if (this.fieldsMetricPropertyEnabled) {
            Arrays.stream(this.fieldsMetricProperty).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("fields[metric-property]", value.text));
            });
        }
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getHeaderParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("revision", this.revision));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class AdditionalFieldsMetricPropertyEnabledRef
    implements BooleanReference {
        private AdditionalFieldsMetricPropertyEnabledRef() {
        }
    }

    static final class Additional_Fields_Metric_Property
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=Additional_Fields_Metric_PropertyChoicesProvider.class)
        String text;

        Additional_Fields_Metric_Property() {
        }

        Additional_Fields_Metric_Property(String text) {
            this.text = text;
        }

        private static final class Additional_Fields_Metric_PropertyChoicesProvider
        implements StringChoicesProvider {
            private Additional_Fields_Metric_PropertyChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(ADDITIONAL_FIELDS_METRIC_PROPERTY_VALUES);
            }
        }
    }

    private static final class Additional_Fields_Metric_PropertyPersistor
    implements NodeParametersPersistor<Additional_Fields_Metric_Property[]> {
        static final String CONFIG_KEY = "additionalFieldsMetricProperty";

        private Additional_Fields_Metric_PropertyPersistor() {
        }

        public Additional_Fields_Metric_Property[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Additional_Fields_Metric_Property[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Additional_Fields_Metric_Property::new).toArray(Additional_Fields_Metric_Property[]::new);
        }

        public void save(Additional_Fields_Metric_Property[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class FieldsMetricPropertyEnabledRef
    implements BooleanReference {
        private FieldsMetricPropertyEnabledRef() {
        }
    }

    static final class Fields_Metric_Property
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=Fields_Metric_PropertyChoicesProvider.class)
        String text;

        Fields_Metric_Property() {
        }

        Fields_Metric_Property(String text) {
            this.text = text;
        }

        private static final class Fields_Metric_PropertyChoicesProvider
        implements StringChoicesProvider {
            private Fields_Metric_PropertyChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(FIELDS_METRIC_PROPERTY_VALUES);
            }
        }
    }

    private static final class Fields_Metric_PropertyPersistor
    implements NodeParametersPersistor<Fields_Metric_Property[]> {
        static final String CONFIG_KEY = "fieldsMetricProperty";

        private Fields_Metric_PropertyPersistor() {
        }

        public Fields_Metric_Property[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Fields_Metric_Property[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Fields_Metric_Property::new).toArray(Fields_Metric_Property[]::new);
        }

        public void save(Fields_Metric_Property[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class GetPropertiesForMetricNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetPropertiesForMetricNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

