/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.klaviyo.operation.getuniversalcontent;

import com.nodepit.nodes.klaviyo.HttpRequestNodeParameters;
import com.nodepit.nodes.klaviyo.NodeParametersUtils;
import com.nodepit.nodes.klaviyo.ResponseMapper;
import com.nodepit.nodes.klaviyo.SimpleResponseMapper;
import com.nodepit.nodes.klaviyo.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class GetUniversalContentNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Id", description="The ID of the universal content\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String id = null;
    @Widget(title="Set Fields[template Universal Content]", description="Enable to set the optional field <b>Fields[template Universal Content]</b>")
    @ValueReference(value=FieldsTemplateUniversalContentEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean fieldsTemplateUniversalContentEnabled = false;
    @Widget(title="Fields[template Universal Content]", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FieldsTemplateUniversalContentEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Fields_Template_Universal_ContentPersistor.class)
    Fields_Template_Universal_Content[] fieldsTemplateUniversalContent = new Fields_Template_Universal_Content[]{new Fields_Template_Universal_Content(FIELDS_TEMPLATE_UNIVERSAL_CONTENT_VALUES[0])};
    private static final String[] FIELDS_TEMPLATE_UNIVERSAL_CONTENT_VALUES = new String[]{"name", "definition", "definition.content_type", "definition.type", "definition.data", "definition.data.content", "definition.data.display_options", "definition.data.display_options.show_on", "definition.data.display_options.visible_check", "definition.data.display_options.content_repeat", "definition.data.display_options.content_repeat.repeat_for", "definition.data.display_options.content_repeat.item_alias", "definition.data.styles", "definition.data.styles.background_color", "definition.data.styles.block_background_color", "definition.data.styles.block_border_color", "definition.data.styles.block_border_style", "definition.data.styles.block_border_width", "definition.data.styles.block_padding_bottom", "definition.data.styles.block_padding_left", "definition.data.styles.block_padding_right", "definition.data.styles.block_padding_top", "definition.data.styles.color", "definition.data.styles.extra_css_class", "definition.data.styles.font_family", "definition.data.styles.font_size", "definition.data.styles.font_style", "definition.data.styles.font_weight", "definition.data.styles.inner_padding_bottom", "definition.data.styles.inner_padding_left", "definition.data.styles.inner_padding_right", "definition.data.styles.inner_padding_top", "definition.data.styles.letter_spacing", "definition.data.styles.line_height", "definition.data.styles.mobile_stretch_content", "definition.data.styles.text_align", "definition.data.styles.text_decoration", "definition.data.styles.text_table_layout", "created", "updated", "screenshot_status", "screenshot_url"};
    @Widget(title="Revision", description="API endpoint revision (format: YYYY-MM-DD[.suffix])\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String revision = "2025-07-15";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Type:</b> </li>\n\t<li><b>Id:</b> The ID of the universal content</li>\n\t<li><b>Attributes:</b> </li>\n\t<li><b>Links:</b> </li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetUniversalContentNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"data\":{\"type\":\"rows[0][0]\",\"id\":\"rows[0][1]\",\"attributes\":\"rows[0][2]\",\"links\":\"rows[0][3]\"}}}]").addBodyColumn(new DataColumnSpecCreator("Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Attributes", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Links", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    GetUniversalContentNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.id == null || this.id.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cId\u201d is required.");
        }
        if (this.revision == null || this.revision.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cRevision\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/vnd.api+json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("id", this.id));
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.fieldsTemplateUniversalContentEnabled) {
            Arrays.stream(this.fieldsTemplateUniversalContent).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("fields[template-universal-content]", value.text));
            });
        }
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getHeaderParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("revision", this.revision));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class FieldsTemplateUniversalContentEnabledRef
    implements BooleanReference {
        private FieldsTemplateUniversalContentEnabledRef() {
        }
    }

    static final class Fields_Template_Universal_Content
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=Fields_Template_Universal_ContentChoicesProvider.class)
        String text;

        Fields_Template_Universal_Content() {
        }

        Fields_Template_Universal_Content(String text) {
            this.text = text;
        }

        private static final class Fields_Template_Universal_ContentChoicesProvider
        implements StringChoicesProvider {
            private Fields_Template_Universal_ContentChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(FIELDS_TEMPLATE_UNIVERSAL_CONTENT_VALUES);
            }
        }
    }

    private static final class Fields_Template_Universal_ContentPersistor
    implements NodeParametersPersistor<Fields_Template_Universal_Content[]> {
        static final String CONFIG_KEY = "fieldsTemplateUniversalContent";

        private Fields_Template_Universal_ContentPersistor() {
        }

        public Fields_Template_Universal_Content[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Fields_Template_Universal_Content[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Fields_Template_Universal_Content::new).toArray(Fields_Template_Universal_Content[]::new);
        }

        public void save(Fields_Template_Universal_Content[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class GetUniversalContentNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetUniversalContentNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

