/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.klaviyo.auth.klaviyoapikey;

import com.nodepit.nodes.klaviyo.InterceptorFactory;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class KlaviyoAPIKeyInterceptorFactory
extends InterceptorFactory<ApiKeyAuthData> {
    public static final String IDENTIFIER = "Klaviyo-API-Key";
    private static final String API_KEY_PREFIX = "Klaviyo-API-Key";

    public KlaviyoAPIKeyInterceptorFactory() {
        super("Klaviyo-API-Key", ApiKeyAuthData.class);
    }

    @Override
    protected Interceptor createInterceptor(final ApiKeyAuthData data) {
        return new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request originalRequest = chain.request();
                Object apikey = data.apiKey;
                if ("Klaviyo-API-Key" != null) {
                    apikey = "Klaviyo-API-Key " + (String)apikey;
                }
                Request authRequest = originalRequest.newBuilder().header("Authorization", (String)apikey).build();
                return chain.proceed(authRequest);
            }
        };
    }

    public static final class ApiKeyAuthData {
        String apiKey;
    }
}

