/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.klaviyo.operation.bulkimportprofiles;

import com.nodepit.nodes.klaviyo.HttpRequestNodeModel;
import com.nodepit.nodes.klaviyo.operation.bulkimportprofiles.BulkImportProfilesNodeParameters;
import com.nodepit.nodes.klaviyo.port.ConfigPortObject;
import org.knime.core.node.NodeFactory;
import org.knime.node.DefaultNode;
import org.knime.node.DefaultNodeFactory;
import org.knime.node.RequirePorts;

public class BulkImportProfilesNodeFactory
extends DefaultNodeFactory {
    private static final DefaultNode NODE = DefaultNode.create().name("Bulk Import Profiles").icon("../../node.png").shortDescription("Bulk Import Profiles").fullDescription("\t\t\t<p>Create a bulk profile import job to create or update a batch of profiles.</p>\n<p>Accepts up to 10,000 profiles per request. The maximum allowed payload size is 5MB. The maximum allowed payload size per-profile is 100KB.</p>\n<p>To learn more, see our <a href=\"https://developers.klaviyo.com/en/docs/use_klaviyos_bulk_profile_import_api\">Bulk Profile Import API guide</a>.<br/><br/><i>Rate limits</i>:<br/>Burst: <tt>10/s</tt><br/>Steady: <tt>150/m</tt></p>\n<p><b>Scopes:</b>\n<tt>lists:write</tt>\n<tt>profiles:write</tt></p>\n").sinceVersion(5, 7, 0).ports(ports -> {
        RequirePorts.PortsAdder portsAdder = ports.addInputPort("Configuration Input", "Configuration data.", ConfigPortObject.TYPE).addOutputTable("Result", "Result of the request depending on the selected <b>Result Format</b>.").addOutputPort("Configuration Output", "Configuration data (this is the same as the input port; it is provided as passthrough for sequentially chaining nodes to declutter your workflow connections).", ConfigPortObject.TYPE);
    }).model(model -> model.parametersClass(BulkImportProfilesNodeParameters.class).configure(HttpRequestNodeModel::configure).execute(HttpRequestNodeModel.buildExecute("POST", "/api/profile-bulk-import-jobs"))).nodeType(NodeFactory.NodeType.Other).keywords(new String[]{"bulk_import_profiles", "POST /api/profile-bulk-import-jobs"});

    public BulkImportProfilesNodeFactory() {
        super(NODE);
    }
}

