/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.klaviyo.operation.getalluniversalcontent;

import com.nodepit.nodes.klaviyo.HttpRequestNodeParameters;
import com.nodepit.nodes.klaviyo.NodeParametersUtils;
import com.nodepit.nodes.klaviyo.ResponseMapper;
import com.nodepit.nodes.klaviyo.SimpleResponseMapper;
import com.nodepit.nodes.klaviyo.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;
import org.knime.node.parameters.widget.number.NumberInputWidgetValidation;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class GetAllUniversalContentNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Set Fields[template Universal Content]", description="Enable to set the optional field <b>Fields[template Universal Content]</b>")
    @ValueReference(value=FieldsTemplateUniversalContentEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean fieldsTemplateUniversalContentEnabled = false;
    @Widget(title="Fields[template Universal Content]", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FieldsTemplateUniversalContentEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Fields_Template_Universal_ContentPersistor.class)
    Fields_Template_Universal_Content[] fieldsTemplateUniversalContent = new Fields_Template_Universal_Content[]{new Fields_Template_Universal_Content(FIELDS_TEMPLATE_UNIVERSAL_CONTENT_VALUES[0])};
    private static final String[] FIELDS_TEMPLATE_UNIVERSAL_CONTENT_VALUES = new String[]{"name", "definition", "definition.content_type", "definition.type", "definition.data", "definition.data.content", "definition.data.display_options", "definition.data.display_options.show_on", "definition.data.display_options.visible_check", "definition.data.display_options.content_repeat", "definition.data.display_options.content_repeat.repeat_for", "definition.data.display_options.content_repeat.item_alias", "definition.data.styles", "definition.data.styles.background_color", "definition.data.styles.block_background_color", "definition.data.styles.block_border_color", "definition.data.styles.block_border_style", "definition.data.styles.block_border_width", "definition.data.styles.block_padding_bottom", "definition.data.styles.block_padding_left", "definition.data.styles.block_padding_right", "definition.data.styles.block_padding_top", "definition.data.styles.color", "definition.data.styles.extra_css_class", "definition.data.styles.font_family", "definition.data.styles.font_size", "definition.data.styles.font_style", "definition.data.styles.font_weight", "definition.data.styles.inner_padding_bottom", "definition.data.styles.inner_padding_left", "definition.data.styles.inner_padding_right", "definition.data.styles.inner_padding_top", "definition.data.styles.letter_spacing", "definition.data.styles.line_height", "definition.data.styles.mobile_stretch_content", "definition.data.styles.text_align", "definition.data.styles.text_decoration", "definition.data.styles.text_table_layout", "created", "updated", "screenshot_status", "screenshot_url"};
    @Widget(title="Set Filter", description="Enable to set the optional field <b>Filter</b>")
    @ValueReference(value=FilterEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean filterEnabled = false;
    @Widget(title="Filter", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#filtering<br/>Allowed field(s)/operator(s):<br/><tt>id</tt>: <tt>any</tt>, <tt>equals</tt><br/><tt>name</tt>: <tt>any</tt>, <tt>equals</tt><br/><tt>created</tt>: <tt>greater-or-equal</tt>, <tt>greater-than</tt>, <tt>less-or-equal</tt>, <tt>less-than</tt><br/><tt>updated</tt>: <tt>greater-or-equal</tt>, <tt>greater-than</tt>, <tt>less-or-equal</tt>, <tt>less-than</tt><br/><tt>definition.content_type</tt>: <tt>equals</tt><br/><tt>definition.type</tt>: <tt>equals</tt>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FilterEnabledRef.class, type=Effect.EffectType.SHOW)
    String filter = null;
    @Widget(title="Set Page[cursor]", description="Enable to set the optional field <b>Page[cursor]</b>")
    @ValueReference(value=PageCursorEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean pageCursorEnabled = false;
    @Widget(title="Page[cursor]", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#pagination\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=PageCursorEnabledRef.class, type=Effect.EffectType.SHOW)
    String pageCursor = null;
    @Widget(title="Set Page[size]", description="Enable to set the optional field <b>Page[size]</b>")
    @ValueReference(value=PageSizeEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean pageSizeEnabled = false;
    @Widget(title="Page[size]", description="Default: 20. Min: 1. Max: 100.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=PageSizeEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget(minValidation=Page_SizeMinValidation.class, maxValidation=Page_SizeMaxValidation.class)
    int pageSize = 20;
    @Widget(title="Set Sort", description="Enable to set the optional field <b>Sort</b>")
    @ValueReference(value=SortEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean sortEnabled = false;
    @Widget(title="Sort", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sorting\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=SortEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=SortChoicesProvider.class)
    String sort = SORT_VALUES[0];
    private static final String[] SORT_VALUES = new String[]{"created", "-created", "id", "-id", "name", "-name", "updated", "-updated"};
    @Widget(title="Revision", description="API endpoint revision (format: YYYY-MM-DD[.suffix])\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String revision = "2025-07-15";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Type:</b> </li>\n\t<li><b>Id:</b> The ID of the universal content</li>\n\t<li><b>Attributes:</b> </li>\n\t<li><b>Links:</b> </li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetAllUniversalContentNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"data\":{\"*\":{\"type\":\"rows[#2][0]\",\"id\":\"rows[#2][1]\",\"attributes\":\"rows[#2][2]\",\"links\":\"rows[#2][3]\"}}}}]").addBodyColumn(new DataColumnSpecCreator("Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Attributes", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Links", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    GetAllUniversalContentNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.revision == null || this.revision.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cRevision\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/vnd.api+json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.fieldsTemplateUniversalContentEnabled) {
            Arrays.stream(this.fieldsTemplateUniversalContent).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("fields[template-universal-content]", value.text));
            });
        }
        if (this.filterEnabled) {
            params.add(new HttpRequestNodeParameters.Param("filter", this.filter));
        }
        if (this.pageCursorEnabled) {
            params.add(new HttpRequestNodeParameters.Param("page[cursor]", this.pageCursor));
        }
        if (this.pageSizeEnabled) {
            params.add(new HttpRequestNodeParameters.Param("page[size]", this.pageSize));
        }
        if (this.sortEnabled) {
            params.add(new HttpRequestNodeParameters.Param("sort", this.sort));
        }
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getHeaderParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("revision", this.revision));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class FieldsTemplateUniversalContentEnabledRef
    implements BooleanReference {
        private FieldsTemplateUniversalContentEnabledRef() {
        }
    }

    static final class Fields_Template_Universal_Content
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=Fields_Template_Universal_ContentChoicesProvider.class)
        String text;

        Fields_Template_Universal_Content() {
        }

        Fields_Template_Universal_Content(String text) {
            this.text = text;
        }

        private static final class Fields_Template_Universal_ContentChoicesProvider
        implements StringChoicesProvider {
            private Fields_Template_Universal_ContentChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(FIELDS_TEMPLATE_UNIVERSAL_CONTENT_VALUES);
            }
        }
    }

    private static final class Fields_Template_Universal_ContentPersistor
    implements NodeParametersPersistor<Fields_Template_Universal_Content[]> {
        static final String CONFIG_KEY = "fieldsTemplateUniversalContent";

        private Fields_Template_Universal_ContentPersistor() {
        }

        public Fields_Template_Universal_Content[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Fields_Template_Universal_Content[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Fields_Template_Universal_Content::new).toArray(Fields_Template_Universal_Content[]::new);
        }

        public void save(Fields_Template_Universal_Content[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class FilterEnabledRef
    implements BooleanReference {
        private FilterEnabledRef() {
        }
    }

    private static final class GetAllUniversalContentNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetAllUniversalContentNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class PageCursorEnabledRef
    implements BooleanReference {
        private PageCursorEnabledRef() {
        }
    }

    private static final class PageSizeEnabledRef
    implements BooleanReference {
        private PageSizeEnabledRef() {
        }
    }

    private static final class Page_SizeMaxValidation
    extends NumberInputWidgetValidation.MaxValidation {
        private Page_SizeMaxValidation() {
        }

        public double getMax() {
            return 100.0;
        }
    }

    private static final class Page_SizeMinValidation
    extends NumberInputWidgetValidation.MinValidation {
        private Page_SizeMinValidation() {
        }

        public double getMin() {
            return 1.0;
        }
    }

    private static final class SortChoicesProvider
    implements StringChoicesProvider {
        private SortChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(SORT_VALUES);
        }
    }

    private static final class SortEnabledRef
    implements BooleanReference {
        private SortEnabledRef() {
        }
    }
}

