/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.klaviyo.operation.getbulkimportprofilesjobs;

import com.nodepit.nodes.klaviyo.HttpRequestNodeParameters;
import com.nodepit.nodes.klaviyo.NodeParametersUtils;
import com.nodepit.nodes.klaviyo.ResponseMapper;
import com.nodepit.nodes.klaviyo.SimpleResponseMapper;
import com.nodepit.nodes.klaviyo.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;
import org.knime.node.parameters.widget.number.NumberInputWidgetValidation;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class GetBulkImportProfilesJobsNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Set Fields[profile Bulk Import Job]", description="Enable to set the optional field <b>Fields[profile Bulk Import Job]</b>")
    @ValueReference(value=FieldsProfileBulkImportJobEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean fieldsProfileBulkImportJobEnabled = false;
    @Widget(title="Fields[profile Bulk Import Job]", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FieldsProfileBulkImportJobEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Fields_Profile_Bulk_Import_JobPersistor.class)
    Fields_Profile_Bulk_Import_Job[] fieldsProfileBulkImportJob = new Fields_Profile_Bulk_Import_Job[]{new Fields_Profile_Bulk_Import_Job(FIELDS_PROFILE_BULK_IMPORT_JOB_VALUES[0])};
    private static final String[] FIELDS_PROFILE_BULK_IMPORT_JOB_VALUES = new String[]{"status", "created_at", "total_count", "completed_count", "failed_count", "completed_at", "expires_at", "started_at"};
    @Widget(title="Set Filter", description="Enable to set the optional field <b>Filter</b>")
    @ValueReference(value=FilterEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean filterEnabled = false;
    @Widget(title="Filter", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#filtering<br/>Allowed field(s)/operator(s):<br/><tt>status</tt>: <tt>any</tt>, <tt>equals</tt>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FilterEnabledRef.class, type=Effect.EffectType.SHOW)
    String filter = null;
    @Widget(title="Set Page[cursor]", description="Enable to set the optional field <b>Page[cursor]</b>")
    @ValueReference(value=PageCursorEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean pageCursorEnabled = false;
    @Widget(title="Page[cursor]", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#pagination\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=PageCursorEnabledRef.class, type=Effect.EffectType.SHOW)
    String pageCursor = null;
    @Widget(title="Set Page[size]", description="Enable to set the optional field <b>Page[size]</b>")
    @ValueReference(value=PageSizeEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean pageSizeEnabled = false;
    @Widget(title="Page[size]", description="Default: 20. Min: 1. Max: 100.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=PageSizeEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget(minValidation=Page_SizeMinValidation.class, maxValidation=Page_SizeMaxValidation.class)
    int pageSize = 20;
    @Widget(title="Set Sort", description="Enable to set the optional field <b>Sort</b>")
    @ValueReference(value=SortEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean sortEnabled = false;
    @Widget(title="Sort", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sorting\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=SortEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=SortChoicesProvider.class)
    String sort = SORT_VALUES[0];
    private static final String[] SORT_VALUES = new String[]{"created_at", "-created_at"};
    @Widget(title="Revision", description="API endpoint revision (format: YYYY-MM-DD[.suffix])\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String revision = "2025-07-15";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Type:</b> </li>\n\t<li><b>Id:</b> Unique identifier for retrieving the job. Generated by Klaviyo.</li>\n\t<li><b>Attributes:</b> </li>\n\t<li><b>Links:</b> </li>\n\t<li><b>Relationships:</b> </li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetBulkImportProfilesJobsNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"data\":{\"*\":{\"type\":\"rows[#2][0]\",\"id\":\"rows[#2][1]\",\"attributes\":\"rows[#2][2]\",\"links\":\"rows[#2][3]\",\"relationships\":\"rows[#2][4]\"}}}}]").addBodyColumn(new DataColumnSpecCreator("Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Attributes", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Links", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Relationships", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    GetBulkImportProfilesJobsNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.revision == null || this.revision.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cRevision\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/vnd.api+json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.fieldsProfileBulkImportJobEnabled) {
            Arrays.stream(this.fieldsProfileBulkImportJob).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("fields[profile-bulk-import-job]", value.text));
            });
        }
        if (this.filterEnabled) {
            params.add(new HttpRequestNodeParameters.Param("filter", this.filter));
        }
        if (this.pageCursorEnabled) {
            params.add(new HttpRequestNodeParameters.Param("page[cursor]", this.pageCursor));
        }
        if (this.pageSizeEnabled) {
            params.add(new HttpRequestNodeParameters.Param("page[size]", this.pageSize));
        }
        if (this.sortEnabled) {
            params.add(new HttpRequestNodeParameters.Param("sort", this.sort));
        }
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getHeaderParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("revision", this.revision));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class FieldsProfileBulkImportJobEnabledRef
    implements BooleanReference {
        private FieldsProfileBulkImportJobEnabledRef() {
        }
    }

    static final class Fields_Profile_Bulk_Import_Job
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=Fields_Profile_Bulk_Import_JobChoicesProvider.class)
        String text;

        Fields_Profile_Bulk_Import_Job() {
        }

        Fields_Profile_Bulk_Import_Job(String text) {
            this.text = text;
        }

        private static final class Fields_Profile_Bulk_Import_JobChoicesProvider
        implements StringChoicesProvider {
            private Fields_Profile_Bulk_Import_JobChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(FIELDS_PROFILE_BULK_IMPORT_JOB_VALUES);
            }
        }
    }

    private static final class Fields_Profile_Bulk_Import_JobPersistor
    implements NodeParametersPersistor<Fields_Profile_Bulk_Import_Job[]> {
        static final String CONFIG_KEY = "fieldsProfileBulkImportJob";

        private Fields_Profile_Bulk_Import_JobPersistor() {
        }

        public Fields_Profile_Bulk_Import_Job[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Fields_Profile_Bulk_Import_Job[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Fields_Profile_Bulk_Import_Job::new).toArray(Fields_Profile_Bulk_Import_Job[]::new);
        }

        public void save(Fields_Profile_Bulk_Import_Job[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class FilterEnabledRef
    implements BooleanReference {
        private FilterEnabledRef() {
        }
    }

    private static final class GetBulkImportProfilesJobsNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetBulkImportProfilesJobsNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class PageCursorEnabledRef
    implements BooleanReference {
        private PageCursorEnabledRef() {
        }
    }

    private static final class PageSizeEnabledRef
    implements BooleanReference {
        private PageSizeEnabledRef() {
        }
    }

    private static final class Page_SizeMaxValidation
    extends NumberInputWidgetValidation.MaxValidation {
        private Page_SizeMaxValidation() {
        }

        public double getMax() {
            return 100.0;
        }
    }

    private static final class Page_SizeMinValidation
    extends NumberInputWidgetValidation.MinValidation {
        private Page_SizeMinValidation() {
        }

        public double getMin() {
            return 1.0;
        }
    }

    private static final class SortChoicesProvider
    implements StringChoicesProvider {
        private SortChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(SORT_VALUES);
        }
    }

    private static final class SortEnabledRef
    implements BooleanReference {
        private SortEnabledRef() {
        }
    }
}

