/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.klaviyo.operation.getclientreviewvaluesreports;

import com.nodepit.nodes.klaviyo.HttpRequestNodeParameters;
import com.nodepit.nodes.klaviyo.NodeParametersUtils;
import com.nodepit.nodes.klaviyo.ResponseMapper;
import com.nodepit.nodes.klaviyo.SimpleResponseMapper;
import com.nodepit.nodes.klaviyo.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;
import org.knime.node.parameters.widget.number.NumberInputWidgetValidation;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class GetClientReviewValuesReportsNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Company Id", description="Your Public API Key / Site ID. See <a href=\"https://help.klaviyo.com/hc/en-us/articles/115005062267\">this article</a> for more details.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String companyId = null;
    @Widget(title="Set Fields[review Values Report]", description="Enable to set the optional field <b>Fields[review Values Report]</b>")
    @ValueReference(value=FieldsReviewValuesReportEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean fieldsReviewValuesReportEnabled = false;
    @Widget(title="Fields[review Values Report]", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FieldsReviewValuesReportEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Fields_Review_Values_ReportPersistor.class)
    Fields_Review_Values_Report[] fieldsReviewValuesReport = new Fields_Review_Values_Report[]{new Fields_Review_Values_Report(FIELDS_REVIEW_VALUES_REPORT_VALUES[0])};
    private static final String[] FIELDS_REVIEW_VALUES_REPORT_VALUES = new String[]{"results"};
    @Widget(title="Set Filter", description="Enable to set the optional field <b>Filter</b>")
    @ValueReference(value=FilterEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean filterEnabled = false;
    @Widget(title="Filter", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#filtering<br/>Allowed field(s)/operator(s):<br/><tt>product_external_ids</tt>: <tt>any</tt>, <tt>equals</tt>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FilterEnabledRef.class, type=Effect.EffectType.SHOW)
    String filter = null;
    @Widget(title="Group By", description="group by value for this report\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=Group_ByChoicesProvider.class)
    String groupBy = GROUP_BY_VALUES[0];
    private static final String[] GROUP_BY_VALUES = new String[]{"company_id", "product_id"};
    @Widget(title="Set Page[cursor]", description="Enable to set the optional field <b>Page[cursor]</b>")
    @ValueReference(value=PageCursorEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean pageCursorEnabled = false;
    @Widget(title="Page[cursor]", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#pagination\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=PageCursorEnabledRef.class, type=Effect.EffectType.SHOW)
    String pageCursor = null;
    @Widget(title="Set Page[size]", description="Enable to set the optional field <b>Page[size]</b>")
    @ValueReference(value=PageSizeEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean pageSizeEnabled = false;
    @Widget(title="Page[size]", description="Default: 20. Min: 1. Max: 100.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=PageSizeEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget(minValidation=Page_SizeMinValidation.class, maxValidation=Page_SizeMaxValidation.class)
    int pageSize = 20;
    @Widget(title="Statistics", description="list of statistics to calculate for this report\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String statistics = null;
    @Widget(title="Timeframe", description="timeframe window for value report\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=TimeframeChoicesProvider.class)
    String timeframe = TIMEFRAME_VALUES[0];
    private static final String[] TIMEFRAME_VALUES = new String[]{"all_time", "last_30_days", "last_365_days", "last_90_days"};
    @Widget(title="Revision", description="API endpoint revision (format: YYYY-MM-DD[.suffix])\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String revision = "2025-07-15";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Type:</b> </li>\n\t<li><b>Id:</b> The unique identifier for the reviews values report</li>\n\t<li><b>Attributes:</b> </li>\n\t<li><b>Links:</b> </li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetClientReviewValuesReportsNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"data\":{\"*\":{\"type\":\"rows[#2][0]\",\"id\":\"rows[#2][1]\",\"attributes\":\"rows[#2][2]\",\"links\":\"rows[#2][3]\"}}}}]").addBodyColumn(new DataColumnSpecCreator("Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Attributes", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Links", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    GetClientReviewValuesReportsNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.companyId == null || this.companyId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cCompany Id\u201d is required.");
        }
        if (this.groupBy == null || this.groupBy.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cGroup By\u201d is required.");
        }
        if (this.statistics == null || this.statistics.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cStatistics\u201d is required.");
        }
        if (this.timeframe == null || this.timeframe.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cTimeframe\u201d is required.");
        }
        if (this.revision == null || this.revision.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cRevision\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/vnd.api+json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("company_id", this.companyId));
        if (this.fieldsReviewValuesReportEnabled) {
            Arrays.stream(this.fieldsReviewValuesReport).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("fields[review-values-report]", value.text));
            });
        }
        if (this.filterEnabled) {
            params.add(new HttpRequestNodeParameters.Param("filter", this.filter));
        }
        params.add(new HttpRequestNodeParameters.Param("group_by", this.groupBy));
        if (this.pageCursorEnabled) {
            params.add(new HttpRequestNodeParameters.Param("page[cursor]", this.pageCursor));
        }
        if (this.pageSizeEnabled) {
            params.add(new HttpRequestNodeParameters.Param("page[size]", this.pageSize));
        }
        params.add(new HttpRequestNodeParameters.Param("statistics", this.statistics));
        params.add(new HttpRequestNodeParameters.Param("timeframe", this.timeframe));
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getHeaderParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("revision", this.revision));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class FieldsReviewValuesReportEnabledRef
    implements BooleanReference {
        private FieldsReviewValuesReportEnabledRef() {
        }
    }

    static final class Fields_Review_Values_Report
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=Fields_Review_Values_ReportChoicesProvider.class)
        String text;

        Fields_Review_Values_Report() {
        }

        Fields_Review_Values_Report(String text) {
            this.text = text;
        }

        private static final class Fields_Review_Values_ReportChoicesProvider
        implements StringChoicesProvider {
            private Fields_Review_Values_ReportChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(FIELDS_REVIEW_VALUES_REPORT_VALUES);
            }
        }
    }

    private static final class Fields_Review_Values_ReportPersistor
    implements NodeParametersPersistor<Fields_Review_Values_Report[]> {
        static final String CONFIG_KEY = "fieldsReviewValuesReport";

        private Fields_Review_Values_ReportPersistor() {
        }

        public Fields_Review_Values_Report[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Fields_Review_Values_Report[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Fields_Review_Values_Report::new).toArray(Fields_Review_Values_Report[]::new);
        }

        public void save(Fields_Review_Values_Report[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class FilterEnabledRef
    implements BooleanReference {
        private FilterEnabledRef() {
        }
    }

    private static final class GetClientReviewValuesReportsNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetClientReviewValuesReportsNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class Group_ByChoicesProvider
    implements StringChoicesProvider {
        private Group_ByChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(GROUP_BY_VALUES);
        }
    }

    private static final class PageCursorEnabledRef
    implements BooleanReference {
        private PageCursorEnabledRef() {
        }
    }

    private static final class PageSizeEnabledRef
    implements BooleanReference {
        private PageSizeEnabledRef() {
        }
    }

    private static final class Page_SizeMaxValidation
    extends NumberInputWidgetValidation.MaxValidation {
        private Page_SizeMaxValidation() {
        }

        public double getMax() {
            return 100.0;
        }
    }

    private static final class Page_SizeMinValidation
    extends NumberInputWidgetValidation.MinValidation {
        private Page_SizeMinValidation() {
        }

        public double getMin() {
            return 1.0;
        }
    }

    private static final class TimeframeChoicesProvider
    implements StringChoicesProvider {
        private TimeframeChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(TIMEFRAME_VALUES);
        }
    }
}

