/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.klaviyo.operation.getcouponcodeidsforcoupon;

import com.nodepit.nodes.klaviyo.HttpRequestNodeParameters;
import com.nodepit.nodes.klaviyo.NodeParametersUtils;
import com.nodepit.nodes.klaviyo.ResponseMapper;
import com.nodepit.nodes.klaviyo.SimpleResponseMapper;
import com.nodepit.nodes.klaviyo.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class GetCouponCodeIdsForCouponNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Id", description="The ID of the coupon to look up the relationship of.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String id = null;
    @Widget(title="Set Filter", description="Enable to set the optional field <b>Filter</b>")
    @ValueReference(value=FilterEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean filterEnabled = false;
    @Widget(title="Filter", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#filtering<br/>Allowed field(s)/operator(s):<br/><tt>expires_at</tt>: <tt>greater-or-equal</tt>, <tt>greater-than</tt>, <tt>less-or-equal</tt>, <tt>less-than</tt><br/><tt>status</tt>: <tt>equals</tt><br/><tt>coupon.id</tt>: <tt>any</tt>, <tt>equals</tt><br/><tt>profile.id</tt>: <tt>any</tt>, <tt>equals</tt>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FilterEnabledRef.class, type=Effect.EffectType.SHOW)
    String filter = null;
    @Widget(title="Set Page[cursor]", description="Enable to set the optional field <b>Page[cursor]</b>")
    @ValueReference(value=PageCursorEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean pageCursorEnabled = false;
    @Widget(title="Page[cursor]", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#pagination\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=PageCursorEnabledRef.class, type=Effect.EffectType.SHOW)
    String pageCursor = null;
    @Widget(title="Revision", description="API endpoint revision (format: YYYY-MM-DD[.suffix])\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String revision = "2025-07-15";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Type:</b> </li>\n\t<li><b>Id:</b> The id of a coupon code is a combination of its unique code and the id of the coupon it is associated with.</li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetCouponCodeIdsForCouponNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"data\":{\"*\":{\"type\":\"rows[#2][0]\",\"id\":\"rows[#2][1]\"}}}}]").addBodyColumn(new DataColumnSpecCreator("Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    GetCouponCodeIdsForCouponNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.id == null || this.id.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cId\u201d is required.");
        }
        if (this.revision == null || this.revision.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cRevision\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/vnd.api+json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("id", this.id));
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.filterEnabled) {
            params.add(new HttpRequestNodeParameters.Param("filter", this.filter));
        }
        if (this.pageCursorEnabled) {
            params.add(new HttpRequestNodeParameters.Param("page[cursor]", this.pageCursor));
        }
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getHeaderParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("revision", this.revision));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class FilterEnabledRef
    implements BooleanReference {
        private FilterEnabledRef() {
        }
    }

    private static final class GetCouponCodeIdsForCouponNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetCouponCodeIdsForCouponNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class PageCursorEnabledRef
    implements BooleanReference {
        private PageCursorEnabledRef() {
        }
    }
}

