/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.klaviyo.operation.getprofile;

import com.nodepit.nodes.klaviyo.HttpRequestNodeParameters;
import com.nodepit.nodes.klaviyo.NodeParametersUtils;
import com.nodepit.nodes.klaviyo.ResponseMapper;
import com.nodepit.nodes.klaviyo.SimpleResponseMapper;
import com.nodepit.nodes.klaviyo.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class GetProfileNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Id", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String id = null;
    @Widget(title="Set Additional Fields[profile]", description="Enable to set the optional field <b>Additional Fields[profile]</b>")
    @ValueReference(value=AdditionalFieldsProfileEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean additionalFieldsProfileEnabled = false;
    @Widget(title="Additional Fields[profile]", description="Request additional fields not included by default in the response. Supported values: 'subscriptions', 'predictive_analytics'\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=AdditionalFieldsProfileEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Additional_Fields_ProfilePersistor.class)
    Additional_Fields_Profile[] additionalFieldsProfile = new Additional_Fields_Profile[]{new Additional_Fields_Profile(ADDITIONAL_FIELDS_PROFILE_VALUES[0])};
    private static final String[] ADDITIONAL_FIELDS_PROFILE_VALUES = new String[]{"subscriptions", "predictive_analytics"};
    @Widget(title="Set Fields[list]", description="Enable to set the optional field <b>Fields[list]</b>")
    @ValueReference(value=FieldsListEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean fieldsListEnabled = false;
    @Widget(title="Fields[list]", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FieldsListEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Fields_ListPersistor.class)
    Fields_List[] fieldsList = new Fields_List[]{new Fields_List(FIELDS_LIST_VALUES[0])};
    private static final String[] FIELDS_LIST_VALUES = new String[]{"name", "created", "updated", "opt_in_process"};
    @Widget(title="Set Fields[profile]", description="Enable to set the optional field <b>Fields[profile]</b>")
    @ValueReference(value=FieldsProfileEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean fieldsProfileEnabled = false;
    @Widget(title="Fields[profile]", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FieldsProfileEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Fields_ProfilePersistor.class)
    Fields_Profile[] fieldsProfile = new Fields_Profile[]{new Fields_Profile(FIELDS_PROFILE_VALUES[0])};
    private static final String[] FIELDS_PROFILE_VALUES = new String[]{"email", "phone_number", "external_id", "first_name", "last_name", "organization", "locale", "title", "image", "created", "updated", "last_event_date", "location", "location.address1", "location.address2", "location.city", "location.country", "location.latitude", "location.longitude", "location.region", "location.zip", "location.timezone", "location.ip", "properties", "subscriptions", "subscriptions.email", "subscriptions.email.marketing", "subscriptions.email.marketing.can_receive_email_marketing", "subscriptions.email.marketing.consent", "subscriptions.email.marketing.consent_timestamp", "subscriptions.email.marketing.last_updated", "subscriptions.email.marketing.method", "subscriptions.email.marketing.method_detail", "subscriptions.email.marketing.custom_method_detail", "subscriptions.email.marketing.double_optin", "subscriptions.email.marketing.suppression", "subscriptions.email.marketing.list_suppressions", "subscriptions.sms", "subscriptions.sms.marketing", "subscriptions.sms.marketing.can_receive_sms_marketing", "subscriptions.sms.marketing.consent", "subscriptions.sms.marketing.consent_timestamp", "subscriptions.sms.marketing.method", "subscriptions.sms.marketing.method_detail", "subscriptions.sms.marketing.last_updated", "subscriptions.sms.transactional", "subscriptions.sms.transactional.can_receive_sms_transactional", "subscriptions.sms.transactional.consent", "subscriptions.sms.transactional.consent_timestamp", "subscriptions.sms.transactional.method", "subscriptions.sms.transactional.method_detail", "subscriptions.sms.transactional.last_updated", "subscriptions.mobile_push", "subscriptions.mobile_push.marketing", "subscriptions.mobile_push.marketing.can_receive_push_marketing", "subscriptions.mobile_push.marketing.consent", "subscriptions.mobile_push.marketing.consent_timestamp", "subscriptions.whatsapp", "subscriptions.whatsapp.marketing", "subscriptions.whatsapp.marketing.consent", "subscriptions.whatsapp.marketing.consent_timestamp", "subscriptions.whatsapp.marketing.last_updated", "subscriptions.whatsapp.marketing.created_timestamp", "subscriptions.whatsapp.marketing.metadata", "subscriptions.whatsapp.marketing.can_receive", "subscriptions.whatsapp.marketing.valid_until", "subscriptions.whatsapp.marketing.phone_number", "subscriptions.whatsapp.transactional", "subscriptions.whatsapp.transactional.consent", "subscriptions.whatsapp.transactional.consent_timestamp", "subscriptions.whatsapp.transactional.last_updated", "subscriptions.whatsapp.transactional.created_timestamp", "subscriptions.whatsapp.transactional.metadata", "subscriptions.whatsapp.transactional.can_receive", "subscriptions.whatsapp.transactional.valid_until", "subscriptions.whatsapp.transactional.phone_number", "subscriptions.whatsapp.conversational", "subscriptions.whatsapp.conversational.consent", "subscriptions.whatsapp.conversational.consent_timestamp", "subscriptions.whatsapp.conversational.last_updated", "subscriptions.whatsapp.conversational.created_timestamp", "subscriptions.whatsapp.conversational.metadata", "subscriptions.whatsapp.conversational.can_receive", "subscriptions.whatsapp.conversational.valid_until", "subscriptions.whatsapp.conversational.phone_number", "predictive_analytics", "predictive_analytics.historic_clv", "predictive_analytics.predicted_clv", "predictive_analytics.total_clv", "predictive_analytics.historic_number_of_orders", "predictive_analytics.predicted_number_of_orders", "predictive_analytics.average_days_between_orders", "predictive_analytics.average_order_value", "predictive_analytics.churn_probability", "predictive_analytics.expected_date_of_next_order", "predictive_analytics.ranked_channel_affinity"};
    @Widget(title="Set Fields[push Token]", description="Enable to set the optional field <b>Fields[push Token]</b>")
    @ValueReference(value=FieldsPushTokenEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean fieldsPushTokenEnabled = false;
    @Widget(title="Fields[push Token]", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FieldsPushTokenEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Fields_Push_TokenPersistor.class)
    Fields_Push_Token[] fieldsPushToken = new Fields_Push_Token[]{new Fields_Push_Token(FIELDS_PUSH_TOKEN_VALUES[0])};
    private static final String[] FIELDS_PUSH_TOKEN_VALUES = new String[]{"created", "token", "enablement_status", "platform", "vendor", "background", "recorded_date", "metadata", "metadata.device_id", "metadata.klaviyo_sdk", "metadata.sdk_version", "metadata.device_model", "metadata.os_name", "metadata.os_version", "metadata.manufacturer", "metadata.app_name", "metadata.app_version", "metadata.app_build", "metadata.app_id", "metadata.environment"};
    @Widget(title="Set Fields[segment]", description="Enable to set the optional field <b>Fields[segment]</b>")
    @ValueReference(value=FieldsSegmentEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean fieldsSegmentEnabled = false;
    @Widget(title="Fields[segment]", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FieldsSegmentEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Fields_SegmentPersistor.class)
    Fields_Segment[] fieldsSegment = new Fields_Segment[]{new Fields_Segment(FIELDS_SEGMENT_VALUES[0])};
    private static final String[] FIELDS_SEGMENT_VALUES = new String[]{"name", "definition", "definition.condition_groups", "created", "updated", "is_active", "is_processing", "is_starred"};
    @Widget(title="Set Include", description="Enable to set the optional field <b>Include</b>")
    @ValueReference(value=IncludeEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean includeEnabled = false;
    @Widget(title="Include", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=IncludeEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=IncludePersistor.class)
    Include[] include = new Include[]{new Include(INCLUDE_VALUES[0])};
    private static final String[] INCLUDE_VALUES = new String[]{"lists", "push-tokens", "segments"};
    @Widget(title="Revision", description="API endpoint revision (format: YYYY-MM-DD[.suffix])\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String revision = "2025-07-15";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Type:</b> </li>\n\t<li><b>Id:</b> Primary key that uniquely identifies this profile. Generated by Klaviyo.</li>\n\t<li><b>Attributes:</b> </li>\n\t<li><b>Links:</b> </li>\n\t<li><b>Relationships:</b> </li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetProfileNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"data\":{\"type\":\"rows[0][0]\",\"id\":\"rows[0][1]\",\"attributes\":\"rows[0][2]\",\"links\":\"rows[0][3]\",\"relationships\":\"rows[0][4]\"}}}]").addBodyColumn(new DataColumnSpecCreator("Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Attributes", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Links", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Relationships", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    GetProfileNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.id == null || this.id.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cId\u201d is required.");
        }
        if (this.revision == null || this.revision.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cRevision\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/vnd.api+json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("id", this.id));
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.additionalFieldsProfileEnabled) {
            Arrays.stream(this.additionalFieldsProfile).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("additional-fields[profile]", value.text));
            });
        }
        if (this.fieldsListEnabled) {
            Arrays.stream(this.fieldsList).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("fields[list]", value.text));
            });
        }
        if (this.fieldsProfileEnabled) {
            Arrays.stream(this.fieldsProfile).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("fields[profile]", value.text));
            });
        }
        if (this.fieldsPushTokenEnabled) {
            Arrays.stream(this.fieldsPushToken).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("fields[push-token]", value.text));
            });
        }
        if (this.fieldsSegmentEnabled) {
            Arrays.stream(this.fieldsSegment).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("fields[segment]", value.text));
            });
        }
        if (this.includeEnabled) {
            Arrays.stream(this.include).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("include", value.text));
            });
        }
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getHeaderParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("revision", this.revision));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class AdditionalFieldsProfileEnabledRef
    implements BooleanReference {
        private AdditionalFieldsProfileEnabledRef() {
        }
    }

    static final class Additional_Fields_Profile
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=Additional_Fields_ProfileChoicesProvider.class)
        String text;

        Additional_Fields_Profile() {
        }

        Additional_Fields_Profile(String text) {
            this.text = text;
        }

        private static final class Additional_Fields_ProfileChoicesProvider
        implements StringChoicesProvider {
            private Additional_Fields_ProfileChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(ADDITIONAL_FIELDS_PROFILE_VALUES);
            }
        }
    }

    private static final class Additional_Fields_ProfilePersistor
    implements NodeParametersPersistor<Additional_Fields_Profile[]> {
        static final String CONFIG_KEY = "additionalFieldsProfile";

        private Additional_Fields_ProfilePersistor() {
        }

        public Additional_Fields_Profile[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Additional_Fields_Profile[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Additional_Fields_Profile::new).toArray(Additional_Fields_Profile[]::new);
        }

        public void save(Additional_Fields_Profile[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class FieldsListEnabledRef
    implements BooleanReference {
        private FieldsListEnabledRef() {
        }
    }

    private static final class FieldsProfileEnabledRef
    implements BooleanReference {
        private FieldsProfileEnabledRef() {
        }
    }

    private static final class FieldsPushTokenEnabledRef
    implements BooleanReference {
        private FieldsPushTokenEnabledRef() {
        }
    }

    private static final class FieldsSegmentEnabledRef
    implements BooleanReference {
        private FieldsSegmentEnabledRef() {
        }
    }

    static final class Fields_List
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=Fields_ListChoicesProvider.class)
        String text;

        Fields_List() {
        }

        Fields_List(String text) {
            this.text = text;
        }

        private static final class Fields_ListChoicesProvider
        implements StringChoicesProvider {
            private Fields_ListChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(FIELDS_LIST_VALUES);
            }
        }
    }

    private static final class Fields_ListPersistor
    implements NodeParametersPersistor<Fields_List[]> {
        static final String CONFIG_KEY = "fieldsList";

        private Fields_ListPersistor() {
        }

        public Fields_List[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Fields_List[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Fields_List::new).toArray(Fields_List[]::new);
        }

        public void save(Fields_List[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    static final class Fields_Profile
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=Fields_ProfileChoicesProvider.class)
        String text;

        Fields_Profile() {
        }

        Fields_Profile(String text) {
            this.text = text;
        }

        private static final class Fields_ProfileChoicesProvider
        implements StringChoicesProvider {
            private Fields_ProfileChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(FIELDS_PROFILE_VALUES);
            }
        }
    }

    private static final class Fields_ProfilePersistor
    implements NodeParametersPersistor<Fields_Profile[]> {
        static final String CONFIG_KEY = "fieldsProfile";

        private Fields_ProfilePersistor() {
        }

        public Fields_Profile[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Fields_Profile[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Fields_Profile::new).toArray(Fields_Profile[]::new);
        }

        public void save(Fields_Profile[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    static final class Fields_Push_Token
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=Fields_Push_TokenChoicesProvider.class)
        String text;

        Fields_Push_Token() {
        }

        Fields_Push_Token(String text) {
            this.text = text;
        }

        private static final class Fields_Push_TokenChoicesProvider
        implements StringChoicesProvider {
            private Fields_Push_TokenChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(FIELDS_PUSH_TOKEN_VALUES);
            }
        }
    }

    private static final class Fields_Push_TokenPersistor
    implements NodeParametersPersistor<Fields_Push_Token[]> {
        static final String CONFIG_KEY = "fieldsPushToken";

        private Fields_Push_TokenPersistor() {
        }

        public Fields_Push_Token[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Fields_Push_Token[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Fields_Push_Token::new).toArray(Fields_Push_Token[]::new);
        }

        public void save(Fields_Push_Token[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    static final class Fields_Segment
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=Fields_SegmentChoicesProvider.class)
        String text;

        Fields_Segment() {
        }

        Fields_Segment(String text) {
            this.text = text;
        }

        private static final class Fields_SegmentChoicesProvider
        implements StringChoicesProvider {
            private Fields_SegmentChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(FIELDS_SEGMENT_VALUES);
            }
        }
    }

    private static final class Fields_SegmentPersistor
    implements NodeParametersPersistor<Fields_Segment[]> {
        static final String CONFIG_KEY = "fieldsSegment";

        private Fields_SegmentPersistor() {
        }

        public Fields_Segment[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Fields_Segment[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Fields_Segment::new).toArray(Fields_Segment[]::new);
        }

        public void save(Fields_Segment[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class GetProfileNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetProfileNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    static final class Include
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=IncludeChoicesProvider.class)
        String text;

        Include() {
        }

        Include(String text) {
            this.text = text;
        }

        private static final class IncludeChoicesProvider
        implements StringChoicesProvider {
            private IncludeChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(INCLUDE_VALUES);
            }
        }
    }

    private static final class IncludeEnabledRef
    implements BooleanReference {
        private IncludeEnabledRef() {
        }
    }

    private static final class IncludePersistor
    implements NodeParametersPersistor<Include[]> {
        static final String CONFIG_KEY = "include";

        private IncludePersistor() {
        }

        public Include[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Include[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Include::new).toArray(Include[]::new);
        }

        public void save(Include[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }
}

