/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.klaviyo.operation.getpushtokensforprofile;

import com.nodepit.nodes.klaviyo.HttpRequestNodeParameters;
import com.nodepit.nodes.klaviyo.NodeParametersUtils;
import com.nodepit.nodes.klaviyo.ResponseMapper;
import com.nodepit.nodes.klaviyo.SimpleResponseMapper;
import com.nodepit.nodes.klaviyo.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class GetPushTokensForProfileNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Id", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String id = null;
    @Widget(title="Set Fields[push Token]", description="Enable to set the optional field <b>Fields[push Token]</b>")
    @ValueReference(value=FieldsPushTokenEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean fieldsPushTokenEnabled = false;
    @Widget(title="Fields[push Token]", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FieldsPushTokenEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Fields_Push_TokenPersistor.class)
    Fields_Push_Token[] fieldsPushToken = new Fields_Push_Token[]{new Fields_Push_Token(FIELDS_PUSH_TOKEN_VALUES[0])};
    private static final String[] FIELDS_PUSH_TOKEN_VALUES = new String[]{"created", "token", "enablement_status", "platform", "vendor", "background", "recorded_date", "metadata", "metadata.device_id", "metadata.klaviyo_sdk", "metadata.sdk_version", "metadata.device_model", "metadata.os_name", "metadata.os_version", "metadata.manufacturer", "metadata.app_name", "metadata.app_version", "metadata.app_build", "metadata.app_id", "metadata.environment"};
    @Widget(title="Revision", description="API endpoint revision (format: YYYY-MM-DD[.suffix])\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String revision = "2025-07-15";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Type:</b> </li>\n\t<li><b>Id:</b> ID of push token</li>\n\t<li><b>Attributes:</b> </li>\n\t<li><b>Links:</b> </li>\n\t<li><b>Relationships:</b> </li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetPushTokensForProfileNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"data\":{\"*\":{\"type\":\"rows[#2][0]\",\"id\":\"rows[#2][1]\",\"attributes\":\"rows[#2][2]\",\"links\":\"rows[#2][3]\",\"relationships\":\"rows[#2][4]\"}}}}]").addBodyColumn(new DataColumnSpecCreator("Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Attributes", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Links", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Relationships", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    GetPushTokensForProfileNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.id == null || this.id.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cId\u201d is required.");
        }
        if (this.revision == null || this.revision.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cRevision\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/vnd.api+json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("id", this.id));
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.fieldsPushTokenEnabled) {
            Arrays.stream(this.fieldsPushToken).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("fields[push-token]", value.text));
            });
        }
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getHeaderParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("revision", this.revision));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class FieldsPushTokenEnabledRef
    implements BooleanReference {
        private FieldsPushTokenEnabledRef() {
        }
    }

    static final class Fields_Push_Token
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=Fields_Push_TokenChoicesProvider.class)
        String text;

        Fields_Push_Token() {
        }

        Fields_Push_Token(String text) {
            this.text = text;
        }

        private static final class Fields_Push_TokenChoicesProvider
        implements StringChoicesProvider {
            private Fields_Push_TokenChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(FIELDS_PUSH_TOKEN_VALUES);
            }
        }
    }

    private static final class Fields_Push_TokenPersistor
    implements NodeParametersPersistor<Fields_Push_Token[]> {
        static final String CONFIG_KEY = "fieldsPushToken";

        private Fields_Push_TokenPersistor() {
        }

        public Fields_Push_Token[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Fields_Push_Token[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Fields_Push_Token::new).toArray(Fields_Push_Token[]::new);
        }

        public void save(Fields_Push_Token[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class GetPushTokensForProfileNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetPushTokensForProfileNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

