/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.klaviyo.operation.mergeprofiles;

import com.nodepit.nodes.klaviyo.HttpRequestNodeModel;
import com.nodepit.nodes.klaviyo.operation.mergeprofiles.MergeProfilesNodeParameters;
import com.nodepit.nodes.klaviyo.port.ConfigPortObject;
import org.knime.core.node.NodeFactory;
import org.knime.node.DefaultNode;
import org.knime.node.DefaultNodeFactory;
import org.knime.node.RequirePorts;

public class MergeProfilesNodeFactory
extends DefaultNodeFactory {
    private static final DefaultNode NODE = DefaultNode.create().name("Merge Profiles").icon("../../node.png").shortDescription("Merge Profiles").fullDescription("\t\t\t<p>Merge a given related profile into a profile with the given profile ID.</p>\n<p>The profile provided under <tt>relationships</tt> (the &quot;source&quot; profile) will be merged into the profile provided by the ID in the base data object (the &quot;destination&quot; profile).\nThis endpoint queues an asynchronous task which will merge data from the source profile into the destination profile, deleting the source profile in the process. This endpoint accepts only one source profile.</p>\n<p>To learn more about how profile data is preserved or overwritten during a merge, please <a href=\"https://help.klaviyo.com/hc/en-us/articles/115005073847#merge-2-profiles3\">visit our Help Center</a>.<br/><br/><i>Rate limits</i>:<br/>Burst: <tt>10/s</tt><br/>Steady: <tt>150/m</tt></p>\n<p><b>Scopes:</b>\n<tt>profiles:write</tt></p>\n").sinceVersion(5, 7, 0).ports(ports -> {
        RequirePorts.PortsAdder portsAdder = ports.addInputPort("Configuration Input", "Configuration data.", ConfigPortObject.TYPE).addOutputTable("Result", "Result of the request depending on the selected <b>Result Format</b>.").addOutputPort("Configuration Output", "Configuration data (this is the same as the input port; it is provided as passthrough for sequentially chaining nodes to declutter your workflow connections).", ConfigPortObject.TYPE);
    }).model(model -> model.parametersClass(MergeProfilesNodeParameters.class).configure(HttpRequestNodeModel::configure).execute(HttpRequestNodeModel.buildExecute("POST", "/api/profile-merge"))).nodeType(NodeFactory.NodeType.Other).keywords(new String[]{"merge_profiles", "POST /api/profile-merge"});

    public MergeProfilesNodeFactory() {
        super(NODE);
    }
}

