/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.klaviyo.operation.rendertemplate;

import com.nodepit.nodes.klaviyo.HttpRequestNodeModel;
import com.nodepit.nodes.klaviyo.operation.rendertemplate.RenderTemplateNodeParameters;
import com.nodepit.nodes.klaviyo.port.ConfigPortObject;
import org.knime.core.node.NodeFactory;
import org.knime.node.DefaultNode;
import org.knime.node.DefaultNodeFactory;
import org.knime.node.RequirePorts;

public class RenderTemplateNodeFactory
extends DefaultNodeFactory {
    private static final DefaultNode NODE = DefaultNode.create().name("Render Template").icon("../../node.png").shortDescription("Render Template").fullDescription("\t\t\t<p>Render a template with the given template ID and context attribute. Returns the AMP, HTML, and plain text versions of the email template.</p>\n<p><b>Request body parameters</b> (nested under <tt>attributes</tt>):</p>\n<ul>\n<li>\n<p><tt>return_fields</tt>: Request specific fields using <a href=\"https://developers.klaviyo.com/en/reference/api_overview#sparse-fieldsets\">sparse fieldsets</a>.</p>\n</li>\n<li>\n<p><tt>context</tt>: This is the context your email template will be rendered with. You must pass in a <tt>context</tt> object as a JSON object.</p>\n</li>\n</ul>\n<p>Email templates are rendered with contexts in a similar manner to Django templates. Nested template variables can be referenced via dot notation. Template variables without corresponding <tt>context</tt> values are treated as <tt>FALSE</tt> and output nothing.</p>\n<p>Ex. <tt>{ &quot;name&quot; : &quot;George Washington&quot;, &quot;state&quot; : &quot;VA&quot; }</tt><br/><br/><i>Rate limits</i>:<br/>Burst: <tt>3/s</tt><br/>Steady: <tt>60/m</tt></p>\n<p><b>Scopes:</b>\n<tt>templates:read</tt></p>\n").sinceVersion(5, 7, 0).ports(ports -> {
        RequirePorts.PortsAdder portsAdder = ports.addInputPort("Configuration Input", "Configuration data.", ConfigPortObject.TYPE).addOutputTable("Result", "Result of the request depending on the selected <b>Result Format</b>.").addOutputPort("Configuration Output", "Configuration data (this is the same as the input port; it is provided as passthrough for sequentially chaining nodes to declutter your workflow connections).", ConfigPortObject.TYPE);
    }).model(model -> model.parametersClass(RenderTemplateNodeParameters.class).configure(HttpRequestNodeModel::configure).execute(HttpRequestNodeModel.buildExecute("POST", "/api/template-render"))).nodeType(NodeFactory.NodeType.Other).keywords(new String[]{"render_template", "POST /api/template-render"});

    public RenderTemplateNodeFactory() {
        super(NODE);
    }
}

