/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.klaviyo.operation.uploadimagefromfile;

import com.nodepit.nodes.klaviyo.HttpRequestNodeParameters;
import com.nodepit.nodes.klaviyo.NodeParametersUtils;
import com.nodepit.nodes.klaviyo.ResponseMapper;
import com.nodepit.nodes.klaviyo.SimpleResponseMapper;
import com.nodepit.nodes.klaviyo.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class UploadImageFromFileNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Revision", description="API endpoint revision (format: YYYY-MM-DD[.suffix])\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String revision = "2025-07-15";
    @Widget(title="File", description="The image file to upload. Supported image formats: jpeg,png,gif. Maximum image size: 5MB.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @LocalFileReaderWidget
    String file = "";
    @Widget(title="Set Name", description="Enable to set the optional field <b>Name</b>")
    @ValueReference(value=NameEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean nameEnabled = false;
    @Widget(title="Name", description="A name for the image.  Defaults to the filename if not provided.  If the name matches an existing image, a suffix will be added.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=NameEnabledRef.class, type=Effect.EffectType.SHOW)
    String name = null;
    @Widget(title="Set Hidden", description="Enable to set the optional field <b>Hidden</b>")
    @ValueReference(value=HiddenEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean hiddenEnabled = false;
    @Widget(title="Hidden", description="If true, this image is not shown in the asset library.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=HiddenEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=HiddenPersistor.class)
    String hidden = "false";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Type:</b> </li>\n\t<li><b>Id:</b> The ID of the image</li>\n\t<li><b>Attributes:</b> </li>\n\t<li><b>Links:</b> </li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=UploadImageFromFileNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"data\":{\"type\":\"rows[0][0]\",\"id\":\"rows[0][1]\",\"attributes\":\"rows[0][2]\",\"links\":\"rows[0][3]\"}}}]").addBodyColumn(new DataColumnSpecCreator("Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Attributes", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Links", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    UploadImageFromFileNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.revision == null || this.revision.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cRevision\u201d is required.");
        }
        if (this.file == null || this.file.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/vnd.api+json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getHeaderParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("revision", this.revision));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.MULTIPART;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getBodyParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("file", new HttpRequestNodeParameters.File(this.file)));
        if (this.nameEnabled) {
            params.add(new HttpRequestNodeParameters.Param("name", String.valueOf(this.name)));
        }
        if (this.hiddenEnabled) {
            params.add(new HttpRequestNodeParameters.Param("hidden", String.valueOf(this.hidden)));
        }
        return params;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class HiddenEnabledRef
    implements BooleanReference {
        private HiddenEnabledRef() {
        }
    }

    private static final class HiddenPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "hidden";

        private HiddenPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class NameEnabledRef
    implements BooleanReference {
        private NameEnabledRef() {
        }
    }

    private static final class UploadImageFromFileNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private UploadImageFromFileNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

