/*
 * Decompiled with CFR 0.152.
 */
package de.philippkatz.knime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.knime.core.data.DataTableSpec;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModel;

public abstract class AbstractSettings {
    private final List<SettingsModelWrap> settingsModels = new ArrayList<SettingsModelWrap>();

    public final void saveSettingsTo(NodeSettingsWO settings) {
        this.getSettingsModelsWrapped().forEach(m -> m.model.saveSettingsTo(settings));
    }

    public final void loadSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        for (SettingsModelWrap model : this.getSettingsModelsWrapped()) {
            model.loadSettingsFrom(settings);
        }
    }

    public final void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        for (SettingsModelWrap model : this.getSettingsModelsWrapped()) {
            model.validateSettings(settings);
        }
    }

    public void validateWithSpec(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        this.validateWithoutSpec();
    }

    public void validateWithoutSpec() throws InvalidSettingsException {
    }

    protected final Collection<SettingsModelWrap> getSettingsModelsWrapped() {
        return Collections.unmodifiableCollection(this.settingsModels);
    }

    protected final void addSettingsModel(SettingsModel model) {
        Objects.requireNonNull(model, "model was null");
        this.settingsModels.add(new SettingsModelWrap(model, false));
    }

    protected final void addSettingsModelIgnoreValidation(SettingsModel model) {
        Objects.requireNonNull(model, "model was null");
        this.settingsModels.add(new SettingsModelWrap(model, true));
    }

    private static final class SettingsModelWrap {
        final SettingsModel model;
        final boolean ignoreLoadOrValidateError;

        SettingsModelWrap(SettingsModel model, boolean ignoreLoadOrValidateError) {
            this.model = model;
            this.ignoreLoadOrValidateError = ignoreLoadOrValidateError;
        }

        void loadSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
            block2: {
                try {
                    this.model.loadSettingsFrom(settings);
                }
                catch (InvalidSettingsException e) {
                    if (this.ignoreLoadOrValidateError) break block2;
                    throw e;
                }
            }
        }

        void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
            block2: {
                try {
                    this.model.validateSettings(settings);
                }
                catch (InvalidSettingsException e) {
                    if (this.ignoreLoadOrValidateError) break block2;
                    throw e;
                }
            }
        }
    }
}

