/*
 * Decompiled with CFR 0.152.
 */
package de.philippkatz.knime.getmail;

import de.philippkatz.knime.AbstractNodeModel;
import de.philippkatz.knime.Utils;
import de.philippkatz.knime.getmail.GetMailSettings;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.DataType;
import org.knime.core.data.RowKey;
import org.knime.core.data.blob.BinaryObjectCellFactory;
import org.knime.core.data.blob.BinaryObjectDataCell;
import org.knime.core.data.collection.ListCell;
import org.knime.core.data.container.DataContainer;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.time.localdatetime.LocalDateTimeCellFactory;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;

class GetMailModel
extends AbstractNodeModel<GetMailSettings> {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(GetMailModel.class);
    private static final DataTableSpec OUTPUT_SPEC_EMAIL_PARTS = GetMailModel.createSpecParts();
    private static final DataTableSpec OUTPUT_SPEC_EMAILS = GetMailModel.createSpecEmails();

    protected GetMailModel() {
        super(0, 2, new GetMailSettings());
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        Thread thread = Thread.currentThread();
        ClassLoader currentClassLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(session.getClass().getClassLoader());
        try {
            Message[] messages;
            Store store = session.getStore(((GetMailSettings)this.getSettings()).getProtocol().getStringValue());
            store.connect(((GetMailSettings)this.getSettings()).getHostName().getStringValue(), ((GetMailSettings)this.getSettings()).getPort().getIntValue(), ((GetMailSettings)this.getSettings()).getUserName().getStringValue(), ((GetMailSettings)this.getSettings()).getPassword().getStringValue());
            Folder folder = store.getFolder(((GetMailSettings)this.getSettings()).getFolderName().getStringValue());
            folder.open(((GetMailSettings)this.getSettings()).getFlagSeen().getBooleanValue() ? 2 : 1);
            BinaryObjectCellFactory binaryCellFactory = new BinaryObjectCellFactory(exec);
            BufferedDataContainer containerParts = exec.createDataContainer(OUTPUT_SPEC_EMAIL_PARTS);
            BufferedDataContainer containerEmails = exec.createDataContainer(OUTPUT_SPEC_EMAILS);
            int numMessages = folder.getMessageCount();
            LOGGER.infoWithFormat("# messages in %s: %s", new Object[]{((GetMailSettings)this.getSettings()).getFolderName().getStringValue(), numMessages});
            long rowIndex = 0L;
            Message[] messageArray = messages = folder.getMessages();
            int n = messages.length;
            int n2 = 0;
            while (n2 < n) {
                Message message = messageArray[n2];
                exec.setProgress((double)(++rowIndex) / (double)numMessages, "Processing email no. " + rowIndex);
                ArrayList<Object> cells = new ArrayList<Object>();
                cells.add(new LongCell((long)message.getMessageNumber()));
                cells.add(Utils.createToStringList(message.getFrom()));
                cells.add(Utils.createStringCell(message.getSubject()));
                cells.add(Utils.createToStringList(message.getRecipients(Message.RecipientType.TO)));
                cells.add(Utils.createToStringList(message.getRecipients(Message.RecipientType.CC)));
                cells.add(Utils.createToStringList(message.getRecipients(Message.RecipientType.BCC)));
                cells.add(Utils.createLocalDateTimeCell(message.getSentDate()));
                cells.add(Utils.createLocalDateTimeCell(message.getReceivedDate()));
                cells.add(BooleanCell.BooleanCellFactory.create((boolean)message.getFlags().contains(Flags.Flag.ANSWERED)));
                cells.add(BooleanCell.BooleanCellFactory.create((boolean)message.getFlags().contains(Flags.Flag.DELETED)));
                cells.add(BooleanCell.BooleanCellFactory.create((boolean)message.getFlags().contains(Flags.Flag.DRAFT)));
                cells.add(BooleanCell.BooleanCellFactory.create((boolean)message.getFlags().contains(Flags.Flag.FLAGGED)));
                cells.add(BooleanCell.BooleanCellFactory.create((boolean)message.getFlags().contains(Flags.Flag.RECENT)));
                cells.add(BooleanCell.BooleanCellFactory.create((boolean)message.getFlags().contains(Flags.Flag.SEEN)));
                containerEmails.addRowToTable((DataRow)new DefaultRow(RowKey.createRowKey((long)containerEmails.size()), cells));
                if (!((GetMailSettings)this.getSettings()).getUnseenOnly().getBooleanValue() || !message.getFlags().contains(Flags.Flag.SEEN)) {
                    if (((GetMailSettings)this.getSettings()).getFlagSeen().getBooleanValue()) {
                        message.setFlag(Flags.Flag.SEEN, true);
                    }
                    this.processBodyPart(Collections.unmodifiableList(cells), "1", (Part)message, (DataContainer)containerParts, binaryCellFactory);
                    exec.checkCanceled();
                }
                ++n2;
            }
            containerParts.close();
            containerEmails.close();
            BufferedDataTable[] bufferedDataTableArray = new BufferedDataTable[]{containerEmails.getTable(), containerParts.getTable()};
            return bufferedDataTableArray;
        }
        finally {
            thread.setContextClassLoader(currentClassLoader);
        }
    }

    private void processBodyPart(List<DataCell> commonCells, String hierarchyId, Part part, DataContainer container, BinaryObjectCellFactory factory) throws MessagingException, IOException {
        ArrayList<DataCell> cells = new ArrayList<DataCell>(commonCells);
        cells.add(Utils.createStringCell(hierarchyId));
        cells.add(Utils.createStringCell(part.getContentType()));
        cells.add(Utils.createStringCell(part.getDisposition()));
        cells.add(Utils.createStringCell(part.getFileName()));
        Object content = part.getContent();
        RowKey rowKey = RowKey.createRowKey((long)container.size());
        if (content instanceof String) {
            String text = (String)content;
            cells.add(Utils.createStringCell(text));
            cells.add(DataType.getMissingCell());
            container.addRowToTable((DataRow)new DefaultRow(rowKey, cells));
        } else if (content instanceof InputStream) {
            InputStream inputStream = (InputStream)content;
            cells.add(DataType.getMissingCell());
            cells.add(factory.create(inputStream));
            container.addRowToTable((DataRow)new DefaultRow(rowKey, cells));
        } else if (content instanceof Multipart) {
            Multipart multipart = (Multipart)content;
            int idx = 0;
            while (idx < multipart.getCount()) {
                this.processBodyPart(commonCells, String.format("%s.%s", hierarchyId, idx + 1), (Part)multipart.getBodyPart(idx), container, factory);
                ++idx;
            }
        } else {
            this.setWarningMessage(String.format("Unsupported content: %s -- skipping.", content.getClass().getName()));
        }
    }

    private static DataTableSpec createSpecEmails() {
        return new DataTableSpecCreator().addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Number", LongCell.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("From", ListCell.getCollectionType((DataType)StringCell.TYPE)).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Subject", StringCell.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("To", ListCell.getCollectionType((DataType)StringCell.TYPE)).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Cc", ListCell.getCollectionType((DataType)StringCell.TYPE)).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Bcc", ListCell.getCollectionType((DataType)StringCell.TYPE)).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Sent", LocalDateTimeCellFactory.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Received", LocalDateTimeCellFactory.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Answered", BooleanCell.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Deleted", BooleanCell.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Draft", BooleanCell.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Flagged", BooleanCell.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Recent", BooleanCell.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Seen", BooleanCell.TYPE).createSpec()}).createSpec();
    }

    private static DataTableSpec createSpecParts() {
        return new DataTableSpecCreator().addColumns(GetMailModel.createSpecEmails()).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Content Hierarchy ID", StringCell.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Content MIME type", StringCell.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Content Disposition", StringCell.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Content File Name", StringCell.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Content (String)", StringCell.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Content (Binary)", BinaryObjectDataCell.TYPE).createSpec()}).createSpec();
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        ((GetMailSettings)this.getSettings()).validateWithSpec(inSpecs);
        return new DataTableSpec[]{OUTPUT_SPEC_EMAILS, OUTPUT_SPEC_EMAIL_PARTS};
    }
}

