/*
 * Decompiled with CFR 0.152.
 */
package de.philippkatz.knime.getmail;

import de.philippkatz.knime.AbstractSettings;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.defaultnodesettings.SettingsModel;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelInteger;
import org.knime.core.node.defaultnodesettings.SettingsModelIntegerBounded;
import org.knime.core.node.defaultnodesettings.SettingsModelPassword;
import org.knime.core.node.defaultnodesettings.SettingsModelString;

class GetMailSettings
extends AbstractSettings {
    private static final String ENCRYPTION_KEY = "wb!mcsfwfpQ_H28oYWsdnfoCv2jc*Q";
    private final SettingsModelString hostNameSetting = new SettingsModelString("hostName", null);
    private final SettingsModelInteger portSetting = new SettingsModelIntegerBounded("port", -1, -1, 65535);
    private final SettingsModelString userNameSetting = new SettingsModelString("userName", null);
    private final SettingsModelPassword passwordSetting = new SettingsModelPassword("password", "wb!mcsfwfpQ_H28oYWsdnfoCv2jc*Q", null);
    private final SettingsModelString protocol;
    private final SettingsModelString folderNameSetting;
    private final SettingsModelBoolean flagSeen;
    private final SettingsModelBoolean unseedOnly;

    public GetMailSettings() {
        this.protocol = new SettingsModelString("protocol", Protocol.IMAPS.value);
        this.folderNameSetting = new SettingsModelString("folderName", "INBOX");
        this.flagSeen = new SettingsModelBoolean("flagSeen", false);
        this.unseedOnly = new SettingsModelBoolean("unseenOnly", false);
        this.addSettingsModel((SettingsModel)this.hostNameSetting);
        this.addSettingsModelIgnoreValidation((SettingsModel)this.portSetting);
        this.addSettingsModel((SettingsModel)this.userNameSetting);
        this.addSettingsModel((SettingsModel)this.passwordSetting);
        this.addSettingsModel((SettingsModel)this.protocol);
        this.addSettingsModel((SettingsModel)this.folderNameSetting);
        this.addSettingsModel((SettingsModel)this.flagSeen);
        this.addSettingsModel((SettingsModel)this.unseedOnly);
    }

    public SettingsModelString getHostName() {
        return this.hostNameSetting;
    }

    public SettingsModelInteger getPort() {
        return this.portSetting;
    }

    public SettingsModelString getUserName() {
        return this.userNameSetting;
    }

    public SettingsModelPassword getPassword() {
        return this.passwordSetting;
    }

    public SettingsModelString getProtocol() {
        return this.protocol;
    }

    public SettingsModelString getFolderName() {
        return this.folderNameSetting;
    }

    public SettingsModelBoolean getFlagSeen() {
        return this.flagSeen;
    }

    public SettingsModelBoolean getUnseenOnly() {
        return this.unseedOnly;
    }

    @Override
    public void validateWithoutSpec() throws InvalidSettingsException {
        if (GetMailSettings.nullOrEmpty(this.hostNameSetting)) {
            throw new InvalidSettingsException("Hostname must be given");
        }
        if (GetMailSettings.nullOrEmpty(this.userNameSetting)) {
            throw new InvalidSettingsException("Username must be given");
        }
        if (GetMailSettings.nullOrEmpty(this.protocol)) {
            throw new InvalidSettingsException("Protocol must be given");
        }
        if (GetMailSettings.nullOrEmpty(this.folderNameSetting)) {
            throw new InvalidSettingsException("Folder Name must be given");
        }
        if (!Protocol.stringValues().contains(this.protocol.getStringValue())) {
            throw new InvalidSettingsException("Protocol must be one of " + String.join((CharSequence)", ", Protocol.stringValues()));
        }
        if (this.portSetting.getIntValue() == 0) {
            throw new InvalidSettingsException("Port number 0 is not allowed, either use -1 or a port larger than zero.");
        }
    }

    private static boolean nullOrEmpty(SettingsModelString stringModel) {
        String stringValue = stringModel.getStringValue();
        return stringModel.getStringValue() == null || stringValue.isEmpty();
    }

    static enum Protocol {
        IMAPS("imaps"),
        POP3S("pop3s");

        private final String value;

        private Protocol(String value) {
            this.value = value;
        }

        String getValue() {
            return this.value;
        }

        static List<String> stringValues() {
            return Arrays.stream(Protocol.values()).map(Protocol::getValue).collect(Collectors.toList());
        }
    }
}

