/*
 * Decompiled with CFR 0.152.
 */
package de.philippkatz.knime.mbox.header.simple;

import de.philippkatz.knime.AbstractNodeModel;
import de.philippkatz.knime.Utils;
import de.philippkatz.knime.mbox.SettingsWithMessageInputColumn;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.MessageBuilder;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.DataType;
import org.knime.core.data.blob.BinaryObjectDataValue;
import org.knime.core.data.collection.ListCell;
import org.knime.core.data.container.AbstractCellFactory;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.time.localdatetime.LocalDateTimeCellFactory;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;

class SimpleHeaderExtractorModel
extends AbstractNodeModel<SettingsWithMessageInputColumn> {
    private static final DataColumnSpec[] OUTPUT_SPEC;

    static {
        ArrayList<DataColumnSpec> specs = new ArrayList<DataColumnSpec>();
        specs.add(new DataColumnSpecCreator("Message ID", StringCell.TYPE).createSpec());
        specs.add(new DataColumnSpecCreator("Subject", StringCell.TYPE).createSpec());
        specs.add(new DataColumnSpecCreator("Date", LocalDateTimeCellFactory.TYPE).createSpec());
        specs.add(new DataColumnSpecCreator("Sender", StringCell.TYPE).createSpec());
        specs.add(new DataColumnSpecCreator("From", ListCell.getCollectionType((DataType)StringCell.TYPE)).createSpec());
        specs.add(new DataColumnSpecCreator("To", ListCell.getCollectionType((DataType)StringCell.TYPE)).createSpec());
        specs.add(new DataColumnSpecCreator("Cc", ListCell.getCollectionType((DataType)StringCell.TYPE)).createSpec());
        specs.add(new DataColumnSpecCreator("Bcc", ListCell.getCollectionType((DataType)StringCell.TYPE)).createSpec());
        specs.add(new DataColumnSpecCreator("Reply To", ListCell.getCollectionType((DataType)StringCell.TYPE)).createSpec());
        OUTPUT_SPEC = specs.toArray(new DataColumnSpec[0]);
    }

    protected SimpleHeaderExtractorModel() {
        super(1, 1, new SettingsWithMessageInputColumn());
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        BufferedDataTable inTable = inData[0];
        final int inColIdx = ((SettingsWithMessageInputColumn)this.getSettings()).getInColIdx(inTable.getSpec());
        ColumnRearranger rearranger = new ColumnRearranger(inTable.getSpec());
        rearranger.append((CellFactory)new AbstractCellFactory(true, OUTPUT_SPEC){

            public DataCell[] getCells(DataRow row) {
                Message message;
                Object[] cells = new DataCell[OUTPUT_SPEC.length];
                Arrays.fill(cells, DataType.getMissingCell());
                DataCell inputCell = row.getCell(inColIdx);
                if (inputCell.isMissing()) {
                    return cells;
                }
                BinaryObjectDataValue binaryValue = (BinaryObjectDataValue)inputCell;
                MessageBuilder messageBuilder = Utils.createMessageBuilder();
                try {
                    message = messageBuilder.parseMessage(binaryValue.openInputStream());
                }
                catch (IOException | MimeException e) {
                    throw new IllegalArgumentException("Error while parsing message", e);
                }
                cells[0] = Utils.createStringCell(message.getMessageId());
                cells[1] = Utils.createStringCell(message.getSubject());
                cells[2] = Utils.createLocalDateTimeCell(message.getDate());
                cells[3] = message.getSender() != null ? Utils.createStringCell(message.getSender().getAddress()) : DataType.getMissingCell();
                cells[4] = Utils.createToStringList(message.getFrom());
                cells[5] = Utils.createToStringList(message.getTo());
                cells[6] = Utils.createToStringList(message.getCc());
                cells[7] = Utils.createToStringList(message.getBcc());
                cells[8] = Utils.createToStringList(message.getReplyTo());
                return cells;
            }
        });
        if (((SettingsWithMessageInputColumn)this.getSettings()).getRemoveInputColumnSetting().getBooleanValue()) {
            rearranger.remove(new int[]{inColIdx});
        }
        BufferedDataTable outTable = exec.createColumnRearrangeTable(inTable, rearranger, (ExecutionMonitor)exec);
        return new BufferedDataTable[]{outTable};
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        ((SettingsWithMessageInputColumn)this.getSettings()).validateWithSpec(inSpecs);
        DataTableSpecCreator specCreator = new DataTableSpecCreator();
        if (!((SettingsWithMessageInputColumn)this.getSettings()).getRemoveInputColumnSetting().getBooleanValue()) {
            specCreator.addColumns(inSpecs[0]);
        }
        specCreator.addColumns(OUTPUT_SPEC);
        return new DataTableSpec[]{specCreator.createSpec()};
    }
}

