/*
 * Decompiled with CFR 0.152.
 */
package de.philippkatz.knime.mbox.read2;

import de.philippkatz.knime.AbstractNodeModel;
import de.philippkatz.knime.mbox.read2.MboxReader2Settings;
import java.io.File;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import org.apache.james.mime4j.mboxiterator.CharBufferWrapper;
import org.apache.james.mime4j.mboxiterator.MboxIterator;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.RowKey;
import org.knime.core.data.blob.BinaryObjectCellFactory;
import org.knime.core.data.blob.BinaryObjectDataCell;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.context.NodeCreationConfiguration;

class MboxReader2Model
extends AbstractNodeModel<MboxReader2Settings> {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(MboxReader2Model.class);
    private static final DataTableSpec OUTPUT_SPEC = new DataTableSpecCreator().addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Content", BinaryObjectDataCell.TYPE).createSpec()}).createSpec();

    protected MboxReader2Model() {
        super(0, 1, new MboxReader2Settings());
    }

    protected MboxReader2Model(NodeCreationConfiguration creationConfig) {
        this();
        creationConfig.getURLConfig().ifPresent(urlConfig -> {
            try {
                ((MboxReader2Settings)this.getSettings()).getFileSetting().setStringValue(new File(urlConfig.getUrl().toURI()).toString());
            }
            catch (URISyntaxException uRISyntaxException) {
                LOGGER.warn((Object)("Could not convert to file path: " + urlConfig.getUrl()));
            }
        });
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        File mbox = ((MboxReader2Settings)this.getSettings()).getFile();
        Charset charset = Charset.forName(((MboxReader2Settings)this.getSettings()).getEncodingSetting().getStringValue());
        int maxMessageSize = ((MboxReader2Settings)this.getSettings()).getMaxMessageSizeSetting().getIntValue() * 1024 * 1024;
        LOGGER.infoWithFormat("Reading mbox from %s with charset %s", new Object[]{mbox, charset});
        MboxIterator iterator = MboxIterator.fromFile((File)mbox).charset(charset).maxMessageSize(maxMessageSize).fromLine(((MboxReader2Settings)this.getSettings()).getFromLinePattern().getStringValue()).build();
        BinaryObjectCellFactory binaryCellFactory = new BinaryObjectCellFactory(exec);
        BufferedDataContainer container = exec.createDataContainer(OUTPUT_SPEC);
        long rowIndex = 0L;
        for (CharBufferWrapper charBufferWrapper : iterator) {
            InputStream inputStream = charBufferWrapper.asInputStream(charset);
            DefaultRow row = new DefaultRow(RowKey.createRowKey((long)rowIndex++), new DataCell[]{binaryCellFactory.create(inputStream)});
            container.addRowToTable((DataRow)row);
            exec.checkCanceled();
            exec.setProgress("Added row " + rowIndex);
        }
        container.close();
        return new BufferedDataTable[]{container.getTable()};
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        ((MboxReader2Settings)this.getSettings()).validateWithSpec(inSpecs);
        return new DataTableSpec[]{OUTPUT_SPEC};
    }
}

