/*
 * Decompiled with CFR 0.152.
 */
package de.philippkatz.knime.mbox.read2;

import de.philippkatz.knime.AbstractSettings;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.knime.core.data.DataTableSpec;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.defaultnodesettings.SettingsModel;
import org.knime.core.node.defaultnodesettings.SettingsModelInteger;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.util.FileUtil;

class MboxReader2Settings
extends AbstractSettings {
    static final String[] CHARSETS = new String[]{StandardCharsets.ISO_8859_1.name(), StandardCharsets.US_ASCII.name(), StandardCharsets.UTF_16.name(), StandardCharsets.UTF_16BE.name(), StandardCharsets.UTF_16LE.name(), StandardCharsets.UTF_8.name()};
    static final String[] FROM_LINE_PATTERNS = new String[]{"^From \\S+@\\S.*\\d{4}$", "^From \\S+.*\\d{4}$"};
    private static final String DEFAULT_CHARSET = StandardCharsets.ISO_8859_1.name();
    private static final int DEFAULT_MAX_MSG_SIZE = 100;
    private static final String KEY_FILE = "file";
    private static final String KEY_ENCODING = "encoding";
    private static final String KEY_MAX_MSG_SIZE = "maxMessageSize";
    private static final String FROM_LINE_PATTERN = "fromLinePattern";
    private final SettingsModelString fileSetting = new SettingsModelString("file", null);
    private final SettingsModelString encodingSetting = new SettingsModelString("encoding", DEFAULT_CHARSET);
    private final SettingsModelInteger maxMessageSizeSetting = new SettingsModelInteger("maxMessageSize", 100);
    private final SettingsModelString fromLinePattern = new SettingsModelString("fromLinePattern", "^From \\S+@\\S.*\\d{4}$");

    MboxReader2Settings() {
        this.addSettingsModel((SettingsModel)this.fileSetting);
        this.addSettingsModel((SettingsModel)this.encodingSetting);
        this.addSettingsModel((SettingsModel)this.maxMessageSizeSetting);
        this.addSettingsModel((SettingsModel)this.fromLinePattern);
    }

    SettingsModelString getFileSetting() {
        return this.fileSetting;
    }

    SettingsModelString getEncodingSetting() {
        return this.encodingSetting;
    }

    SettingsModelInteger getMaxMessageSizeSetting() {
        return this.maxMessageSizeSetting;
    }

    SettingsModelString getFromLinePattern() {
        return this.fromLinePattern;
    }

    @Override
    public void validateWithSpec(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        if (this.fileSetting.getStringValue() == null || this.fileSetting.getStringValue().isEmpty()) {
            throw new InvalidSettingsException("Please configure an input file.");
        }
        if (!this.getFile().isFile()) {
            throw new InvalidSettingsException(String.valueOf(this.fileSetting.getStringValue()) + " does not exist or is not a file.");
        }
    }

    File getFile() {
        try {
            return FileUtil.getFileFromURL((URL)new URL(this.getFileSetting().getStringValue()));
        }
        catch (IllegalArgumentException | MalformedURLException exception) {
            return new File(this.getFileSetting().getStringValue());
        }
    }
}

