/*
 * Decompiled with CFR 0.152.
 */
package de.philippkatz.knime;

import java.io.IOException;
import java.io.Reader;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.james.mime4j.dom.MessageBuilder;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.apache.james.mime4j.stream.MimeConfig;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataType;
import org.knime.core.data.collection.CollectionCellFactory;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.time.localdatetime.LocalDateTimeCellFactory;

public final class Utils {
    private Utils() {
    }

    public static String readerToString(Reader reader) throws IOException {
        int numCharsRead;
        char[] arr = new char[8192];
        StringBuilder buffer = new StringBuilder();
        while ((numCharsRead = reader.read(arr, 0, arr.length)) != -1) {
            buffer.append(arr, 0, numCharsRead);
        }
        reader.close();
        return buffer.toString();
    }

    public static MessageBuilder createMessageBuilder() {
        DefaultMessageBuilder builder = new DefaultMessageBuilder();
        builder.setMimeEntityConfig(new MimeConfig.Builder().setMaxLineLen(-1).setMaxHeaderLen(-1).setMaxHeaderCount(-1).build());
        return builder;
    }

    public static DataCell createStringCell(String value) {
        return value != null ? new StringCell(value) : DataType.getMissingCell();
    }

    public static LocalDateTime dateToLocalDateTime(Date date) {
        Objects.requireNonNull(date, "date was null");
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static DataCell createLocalDateTimeCell(Date value) {
        return value != null ? LocalDateTimeCellFactory.create((LocalDateTime)Utils.dateToLocalDateTime(value)) : DataType.getMissingCell();
    }

    public static DataCell createToStringList(List<?> list) {
        if (list == null) {
            return DataType.getMissingCell();
        }
        List cells = list.stream().map(item -> Utils.createStringCell(item.toString())).collect(Collectors.toList());
        return CollectionCellFactory.createListCell(cells);
    }

    public static DataCell createToStringList(Object[] array) {
        return Utils.createToStringList(array != null ? Arrays.asList(array) : null);
    }
}

