/*
 * Decompiled with CFR 0.152.
 */
package de.philippkatz.knime.mbox;

import de.philippkatz.knime.AbstractSettings;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.blob.BinaryObjectDataValue;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.defaultnodesettings.SettingsModel;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelString;

public class SettingsWithMessageInputColumn
extends AbstractSettings {
    private static final String KEY_INPUT_COLUMN = "input";
    private static final String KEY_REMOVE_INPUT_COLUMN = "removeInputColumn";
    private final SettingsModelString inputColumnSetting = new SettingsModelString("input", null);
    private final SettingsModelBoolean removeInputColumnSetting = new SettingsModelBoolean("removeInputColumn", false);

    public SettingsWithMessageInputColumn() {
        this.addSettingsModel((SettingsModel)this.inputColumnSetting);
        this.addSettingsModel((SettingsModel)this.removeInputColumnSetting);
    }

    public final SettingsModelString getInputColumnSetting() {
        return this.inputColumnSetting;
    }

    public final SettingsModelBoolean getRemoveInputColumnSetting() {
        return this.removeInputColumnSetting;
    }

    public final int getInColIdx(DataTableSpec spec) {
        return spec.findColumnIndex(this.getInputColumnSetting().getStringValue());
    }

    @Override
    public void validateWithSpec(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        if (this.inputColumnSetting.getStringValue() == null || this.inputColumnSetting.getStringValue().isEmpty()) {
            throw new InvalidSettingsException("Please configure an input column.");
        }
        if (inSpecs[0].findColumnIndex(this.inputColumnSetting.getStringValue()) == -1) {
            throw new InvalidSettingsException("The configured input column \"" + this.inputColumnSetting.getStringValue() + "\" is not present in the table");
        }
        if (!inSpecs[0].getColumnSpec(this.inputColumnSetting.getStringValue()).getType().isCompatible(BinaryObjectDataValue.class)) {
            throw new InvalidSettingsException("The configured input column \"" + this.inputColumnSetting.getStringValue() + "\" is not of type " + BinaryObjectDataValue.class.getSimpleName());
        }
    }
}

