/*
 * Decompiled with CFR 0.152.
 */
package de.philippkatz.knime.mbox.header.expert;

import de.philippkatz.knime.AbstractNodeModel;
import de.philippkatz.knime.Utils;
import de.philippkatz.knime.mbox.header.expert.ExpertHeaderExtractorSettings;
import de.philippkatz.knime.mbox.header.expert.MappingStrategy;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.dom.Header;
import org.apache.james.mime4j.dom.MessageBuilder;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.blob.BinaryObjectDataValue;
import org.knime.core.data.container.AbstractCellFactory;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;

class ExpertHeaderExtractorModel
extends AbstractNodeModel<ExpertHeaderExtractorSettings> {
    protected ExpertHeaderExtractorModel() {
        super(1, 1, new ExpertHeaderExtractorSettings());
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        BufferedDataTable inTable = inData[0];
        final int inColIdx = ((ExpertHeaderExtractorSettings)this.getSettings()).getInColIdx(inTable.getSpec());
        final MappingStrategy mappingStrategy = ((ExpertHeaderExtractorSettings)this.getSettings()).getMappingStrategy();
        final DataColumnSpec[] headerSpec = this.createSpec(inTable, exec);
        ColumnRearranger rearranger = new ColumnRearranger(inTable.getSpec());
        rearranger.append((CellFactory)new AbstractCellFactory(true, headerSpec){

            public DataCell[] getCells(DataRow row) {
                Header header;
                Object[] cells = new DataCell[headerSpec.length];
                Arrays.fill(cells, DataType.getMissingCell());
                DataCell inputCell = row.getCell(inColIdx);
                if (inputCell.isMissing()) {
                    return cells;
                }
                BinaryObjectDataValue binaryValue = (BinaryObjectDataValue)inputCell;
                MessageBuilder messageBuilder = Utils.createMessageBuilder();
                try {
                    header = messageBuilder.parseHeader(binaryValue.openInputStream());
                }
                catch (IOException | MimeException e) {
                    throw new IllegalArgumentException("Error while parsing header", e);
                }
                int colIdx = 0;
                while (colIdx < headerSpec.length) {
                    List fields = header.getFields(headerSpec[colIdx].getName());
                    if (fields != null) {
                        cells[colIdx] = mappingStrategy.map(fields);
                    }
                    ++colIdx;
                }
                return cells;
            }
        });
        if (((ExpertHeaderExtractorSettings)this.getSettings()).getRemoveInputColumnSetting().getBooleanValue()) {
            rearranger.remove(new int[]{inColIdx});
        }
        BufferedDataTable outTable = exec.createColumnRearrangeTable(inTable, rearranger, (ExecutionMonitor)exec);
        return new BufferedDataTable[]{outTable};
    }

    private DataColumnSpec[] createSpec(BufferedDataTable table, ExecutionContext exec) throws Exception {
        TreeSet headerNames = new TreeSet();
        long rowIndex = 0L;
        MessageBuilder messageBuilder = Utils.createMessageBuilder();
        int inColIdx = ((ExpertHeaderExtractorSettings)this.getSettings()).getInColIdx(table.getSpec());
        for (DataRow row : table) {
            DataCell inputCell = row.getCell(inColIdx);
            if (!inputCell.isMissing()) {
                BinaryObjectDataValue binaryValue = (BinaryObjectDataValue)inputCell;
                messageBuilder.parseHeader(binaryValue.openInputStream()).forEach(h -> {
                    boolean bl = headerNames.add(h.getName().toLowerCase());
                });
            }
            exec.checkCanceled();
            exec.setProgress("Checked header for row " + ++rowIndex);
        }
        MappingStrategy mappingStrategy = ((ExpertHeaderExtractorSettings)this.getSettings()).getMappingStrategy();
        return (DataColumnSpec[])headerNames.stream().map(h -> new DataColumnSpecCreator(h, mappingStrategy.getDataType()).createSpec()).toArray(DataColumnSpec[]::new);
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        ((ExpertHeaderExtractorSettings)this.getSettings()).validateWithSpec(inSpecs);
        return new DataTableSpec[1];
    }
}

