/*
 * Decompiled with CFR 0.152.
 */
package de.philippkatz.knime.mbox.header.expert;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.james.mime4j.stream.Field;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataType;
import org.knime.core.data.collection.CollectionCellFactory;
import org.knime.core.data.collection.ListCell;
import org.knime.core.data.def.StringCell;

enum MappingStrategy {
    COLLECTION_CELL("Collection Cell"){

        @Override
        public DataCell map(List<Field> fields) {
            return CollectionCellFactory.createListCell((Collection)fields.stream().map((? super T f) -> f.getBody()).map(StringCell::new).collect(Collectors.toList()));
        }

        @Override
        public DataType getDataType() {
            return ListCell.getCollectionType((DataType)StringCell.TYPE);
        }
    }
    ,
    FIRST_STRING("String Cell (first)"){

        @Override
        public DataCell map(List<Field> fields) {
            return fields.size() > 0 ? new StringCell(fields.get(0).getBody()) : DataType.getMissingCell();
        }

        @Override
        public DataType getDataType() {
            return StringCell.TYPE;
        }
    }
    ,
    CONCATENATED_STRING("String Cell (concatenated)"){

        @Override
        public DataCell map(List<Field> fields) {
            return fields.size() > 0 ? new StringCell(fields.stream().map((? super T f) -> f.getBody()).collect(Collectors.joining(", "))) : DataType.getMissingCell();
        }

        @Override
        public DataType getDataType() {
            return StringCell.TYPE;
        }
    };

    final String label;

    private MappingStrategy(String label) {
        this.label = label;
    }

    abstract DataCell map(List<Field> var1);

    abstract DataType getDataType();

    static MappingStrategy getByLabel(String label) {
        return Arrays.stream(MappingStrategy.values()).filter(s -> s.label.equals(label)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown label: " + label));
    }

    static String[] getLabels() {
        return (String[])Arrays.stream(MappingStrategy.values()).map((? super T s) -> s.label).sorted().toArray(String[]::new);
    }
}

