/*
 * Decompiled with CFR 0.152.
 */
package de.philippkatz.knime.mbox.message;

import de.philippkatz.knime.AbstractNodeModel;
import de.philippkatz.knime.Utils;
import de.philippkatz.knime.mbox.SettingsWithMessageInputColumn;
import java.io.IOException;
import java.util.Arrays;
import org.apache.james.mime4j.dom.BinaryBody;
import org.apache.james.mime4j.dom.Body;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.MessageBuilder;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.dom.SingleBody;
import org.apache.james.mime4j.dom.TextBody;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.DataType;
import org.knime.core.data.RowKey;
import org.knime.core.data.blob.BinaryObjectCellFactory;
import org.knime.core.data.blob.BinaryObjectDataCell;
import org.knime.core.data.blob.BinaryObjectDataValue;
import org.knime.core.data.container.DataContainer;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.InvalidSettingsException;

class MessageExtractorModel
extends AbstractNodeModel<SettingsWithMessageInputColumn> {
    static final DataTableSpec OUTPUT_SPEC;

    static {
        DataTableSpecCreator specCreator = new DataTableSpecCreator();
        specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Input ID", StringCell.TYPE).createSpec()});
        specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Body Hierarchy ID", StringCell.TYPE).createSpec()});
        specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Body (String)", StringCell.TYPE).createSpec()});
        specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Body (Binary)", BinaryObjectDataCell.TYPE).createSpec()});
        specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Charset", StringCell.TYPE).createSpec()});
        specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Content Transfer Encoding", StringCell.TYPE).createSpec()});
        specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Disposition Type", StringCell.TYPE).createSpec()});
        specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Filename", StringCell.TYPE).createSpec()});
        specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Mime Type", StringCell.TYPE).createSpec()});
        OUTPUT_SPEC = specCreator.createSpec();
    }

    protected MessageExtractorModel() {
        super(1, 1, new SettingsWithMessageInputColumn());
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        BufferedDataTable inTable = inData[0];
        int inColIdx = ((SettingsWithMessageInputColumn)this.getSettings()).getInColIdx(inTable.getSpec());
        BinaryObjectCellFactory binaryCellFactory = new BinaryObjectCellFactory(exec);
        MessageBuilder messageBuilder = Utils.createMessageBuilder();
        BufferedDataContainer container = exec.createDataContainer(OUTPUT_SPEC);
        long inRowIndex = 0L;
        for (DataRow row : inTable) {
            ++inRowIndex;
            DataCell inputCell = row.getCell(inColIdx);
            if (inputCell.isMissing()) continue;
            BinaryObjectDataValue binaryValue = (BinaryObjectDataValue)inputCell;
            Message message = messageBuilder.parseMessage(binaryValue.openInputStream());
            MessageExtractorModel.appendBody(row.getKey().getString(), "1", message.getBody(), (DataContainer)container, binaryCellFactory);
            exec.checkCanceled();
            exec.setProgress((double)inRowIndex / (double)inTable.size(), "Processed row " + row.getKey());
        }
        container.close();
        BufferedDataTable out = container.getTable();
        return new BufferedDataTable[]{out};
    }

    static void appendBody(String inputId, String hierarchyId, Body body, DataContainer container, BinaryObjectCellFactory factory) throws IOException {
        if (body instanceof Message) {
            MessageExtractorModel.appendBody(inputId, String.valueOf(hierarchyId) + ".1", ((Message)body).getBody(), container, factory);
        } else if (body instanceof Multipart) {
            long currentIdx = 1L;
            for (Entity entity : ((Multipart)body).getBodyParts()) {
                MessageExtractorModel.appendBody(inputId, String.format("%s.%s", hierarchyId, currentIdx++), entity.getBody(), container, factory);
            }
        } else if (body instanceof SingleBody) {
            Object[] cells = new DataCell[9];
            Arrays.fill(cells, DataType.getMissingCell());
            cells[0] = new StringCell(inputId);
            cells[1] = new StringCell(hierarchyId);
            if (body instanceof BinaryBody) {
                cells[3] = factory.create(((BinaryBody)body).getInputStream());
            } else if (body instanceof TextBody) {
                cells[2] = new StringCell(Utils.readerToString(((TextBody)body).getReader()));
            } else {
                throw new IllegalStateException("Unexpected body type: " + body.getClass().getName());
            }
            if (body.getParent() != null) {
                Entity parent = body.getParent();
                cells[4] = Utils.createStringCell(parent.getCharset());
                cells[5] = Utils.createStringCell(parent.getContentTransferEncoding());
                cells[6] = Utils.createStringCell(parent.getDispositionType());
                cells[7] = Utils.createStringCell(parent.getFilename());
                cells[8] = Utils.createStringCell(parent.getMimeType());
            }
            container.addRowToTable((DataRow)new DefaultRow(RowKey.createRowKey((long)container.size()), (DataCell[])cells));
        } else {
            throw new IllegalStateException("Unexpected body type: " + body.getClass().getName());
        }
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        ((SettingsWithMessageInputColumn)this.getSettings()).validateWithSpec(inSpecs);
        return new DataTableSpec[]{OUTPUT_SPEC};
    }
}

