/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.newsapi.v2;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.text.StringCharacterIterator;
import java.util.Locale;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.knime.core.util.FileUtil;

public final class Utils {
    public static String getFilename(String stringValue) {
        return stringValue.substring(stringValue.lastIndexOf(47) + 1);
    }

    public static RequestBody getRequestBody(String stringValue) throws IOException {
        File file = Utils.resolveFile(stringValue);
        return RequestBody.create((MediaType)MediaType.parse((String)Files.probeContentType(file.toPath())), (File)file);
    }

    private static File resolveFile(String filePath) {
        URL url;
        Objects.requireNonNull(filePath, "filePath was null");
        try {
            url = new URL(filePath);
        }
        catch (MalformedURLException malformedURLException) {
            File tmp = new File(filePath);
            if (tmp.isFile() && tmp.canRead()) {
                try {
                    url = tmp.getAbsoluteFile().toURI().toURL();
                }
                catch (MalformedURLException e1) {
                    throw new IllegalArgumentException(e1);
                }
            }
            throw new IllegalArgumentException("File/URL \"" + filePath + "\" cannot be parsed as a URL or represents a non exising file location");
        }
        File resolvedFile = FileUtil.getFileFromURL((URL)url);
        if (resolvedFile == null) {
            throw new IllegalStateException("Could not resolve " + filePath);
        }
        return resolvedFile;
    }

    public static boolean validateJsonBySchema(String json, String schema) {
        Objects.requireNonNull(json, "json was null");
        Objects.requireNonNull(schema, "schema was null");
        try {
            JsonSchemaFactory schemaFactory = JsonSchemaFactory.byDefault();
            JsonSchema jsonSchema = schemaFactory.getJsonSchema(Utils.parseJson(schema));
            ProcessingReport report = jsonSchema.validate(Utils.parseJson(json));
            return report.isSuccess();
        }
        catch (JsonMappingException jsonMappingException) {
            return false;
        }
        catch (JsonProcessingException jsonProcessingException) {
            return false;
        }
        catch (ProcessingException processingException) {
            return false;
        }
    }

    private static JsonNode parseJson(String schema) throws JsonProcessingException, JsonMappingException {
        return (JsonNode)new ObjectMapper().readValue(schema, JsonNode.class);
    }

    public static String humanReadableByteCountSI(long bytes) {
        if (-1000L < bytes && bytes < 1000L) {
            return String.valueOf(bytes) + " B";
        }
        StringCharacterIterator ci = new StringCharacterIterator("kMGTPE");
        while (bytes <= -999950L || bytes >= 999950L) {
            bytes /= 1000L;
            ci.next();
        }
        return String.format(Locale.ENGLISH, "%.1f %cB", (double)bytes / 1000.0, Character.valueOf(ci.current()));
    }

    public static String encodeUrlPathComponent(String pathComponent) {
        Objects.requireNonNull(pathComponent, "name was null");
        try {
            return URLEncoder.encode(pathComponent, "utf8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("utf8 encoding not supported", e);
        }
    }

    private Utils() {
    }
}

