/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.newsapi.v2.operation.getsources;

import com.nodepit.nodes.newsapi.v2.ResponseMapper;
import com.nodepit.nodes.newsapi.v2.SimpleResponseMapper;
import com.nodepit.nodes.newsapi.v2.TransformToTableMapper;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class GetSourcesNodeSettings {
    static final String[] CATEGORY_VALUES = new String[]{"business", "entertainment", "general", "health", "science", "sports", "technology"};
    private static final String CATEGORY_KEY = "category";
    private static final String CATEGORY_DEFAULT_VALUE = CATEGORY_VALUES[0];
    private String category = CATEGORY_DEFAULT_VALUE;
    private static final String CATEGORY_ENABLED_KEY = "categoryEnabled";
    private boolean categoryEnabled = false;
    static final String[] LANGUAGE_VALUES = new String[]{"ar", "de", "en", "es", "fr", "he", "it", "nl", "no", "pt", "ru", "sv", "ud", "zh"};
    private static final String LANGUAGE_KEY = "language";
    private static final String LANGUAGE_DEFAULT_VALUE = LANGUAGE_VALUES[0];
    private String language = LANGUAGE_DEFAULT_VALUE;
    private static final String LANGUAGE_ENABLED_KEY = "languageEnabled";
    private boolean languageEnabled = false;
    static final String[] COUNTRY_VALUES = new String[]{"ae", "ar", "at", "au", "be", "bg", "br", "ca", "ch", "cn", "co", "cu", "cz", "de", "eg", "fr", "gb", "gr", "hk", "hu", "id", "ie", "il", "in", "it", "jp", "kr", "lt", "lv", "ma", "mx", "my", "ng", "nl", "no", "nz", "ph", "pl", "pt", "ro", "rs", "ru", "sa", "se", "sg", "si", "sk", "th", "tr", "tw", "ua", "us", "ve"};
    private static final String COUNTRY_KEY = "country";
    private static final String COUNTRY_DEFAULT_VALUE = COUNTRY_VALUES[0];
    private String country = COUNTRY_DEFAULT_VALUE;
    private static final String COUNTRY_ENABLED_KEY = "countryEnabled";
    private boolean countryEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"sources\":{\"*\":{\"id\":\"rows[#2][0]\",\"name\":\"rows[#2][1]\",\"description\":\"rows[#2][2]\",\"url\":\"rows[#2][3]\",\"category\":\"rows[#2][4]\",\"language\":\"rows[#2][5]\",\"country\":\"rows[#2][6]\"}}}}]").addBodyColumn(new DataColumnSpecCreator("ID", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Description", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("URL", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Category", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Language", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Country", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    GetSourcesNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(CATEGORY_KEY, this.category);
        settings.addBoolean(CATEGORY_ENABLED_KEY, this.categoryEnabled);
        settings.addString(LANGUAGE_KEY, this.language);
        settings.addBoolean(LANGUAGE_ENABLED_KEY, this.languageEnabled);
        settings.addString(COUNTRY_KEY, this.country);
        settings.addBoolean(COUNTRY_ENABLED_KEY, this.countryEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.category = settings.getString(CATEGORY_KEY, CATEGORY_DEFAULT_VALUE);
        this.categoryEnabled = settings.getBoolean(CATEGORY_ENABLED_KEY, false);
        this.language = settings.getString(LANGUAGE_KEY, LANGUAGE_DEFAULT_VALUE);
        this.languageEnabled = settings.getBoolean(LANGUAGE_ENABLED_KEY, false);
        this.country = settings.getString(COUNTRY_KEY, COUNTRY_DEFAULT_VALUE);
        this.countryEnabled = settings.getBoolean(COUNTRY_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String category() {
        return this.category;
    }

    void category(String value) {
        this.category = value;
    }

    boolean categoryEnabled() {
        return this.categoryEnabled;
    }

    void categoryEnabled(boolean value) {
        this.categoryEnabled = value;
    }

    String language() {
        return this.language;
    }

    void language(String value) {
        this.language = value;
    }

    boolean languageEnabled() {
        return this.languageEnabled;
    }

    void languageEnabled(boolean value) {
        this.languageEnabled = value;
    }

    String country() {
        return this.country;
    }

    void country(String value) {
        this.country = value;
    }

    boolean countryEnabled() {
        return this.countryEnabled;
    }

    void countryEnabled(boolean value) {
        this.countryEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

