/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.newsapi.v2.auth.authheader;

import com.nodepit.nodes.newsapi.v2.InterceptorFactory;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class AuthHeaderInterceptorFactory
extends InterceptorFactory<ApiKeyAuthData> {
    public static final String IDENTIFIER = "auth_header";
    private static final String API_KEY_PREFIX = null;

    public AuthHeaderInterceptorFactory() {
        super(IDENTIFIER, ApiKeyAuthData.class);
    }

    @Override
    protected Interceptor createInterceptor(final ApiKeyAuthData data) {
        return new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request originalRequest = chain.request();
                String apikey = data.apiKey;
                if (API_KEY_PREFIX != null) {
                    apikey = String.valueOf(API_KEY_PREFIX) + " " + apikey;
                }
                Request authRequest = originalRequest.newBuilder().header("Authorization", apikey).build();
                return chain.proceed(authRequest);
            }
        };
    }

    public static final class ApiKeyAuthData {
        String apiKey;
    }
}

