/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.newsapi.v2.operation.gettopheadlines;

import com.nodepit.nodes.newsapi.v2.ResponseMapper;
import com.nodepit.nodes.newsapi.v2.SimpleResponseMapper;
import com.nodepit.nodes.newsapi.v2.TransformToTableMapper;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.time.zoneddatetime.ZonedDateTimeCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class GetTopHeadlinesNodeSettings {
    static final String[] COUNTRY_VALUES = new String[]{"ae", "ar", "at", "au", "be", "bg", "br", "ca", "ch", "cn", "co", "cu", "cz", "de", "eg", "fr", "gb", "gr", "hk", "hu", "id", "ie", "il", "in", "it", "jp", "kr", "lt", "lv", "ma", "mx", "my", "ng", "nl", "no", "nz", "ph", "pl", "pt", "ro", "rs", "ru", "sa", "se", "sg", "si", "sk", "th", "tr", "tw", "ua", "us", "ve"};
    private static final String COUNTRY_KEY = "country";
    private static final String COUNTRY_DEFAULT_VALUE = COUNTRY_VALUES[0];
    private String country = COUNTRY_DEFAULT_VALUE;
    private static final String COUNTRY_ENABLED_KEY = "countryEnabled";
    private boolean countryEnabled = false;
    static final String[] CATEGORY_VALUES = new String[]{"business", "entertainment", "general", "health", "science", "sports", "technology"};
    private static final String CATEGORY_KEY = "category";
    private static final String CATEGORY_DEFAULT_VALUE = CATEGORY_VALUES[0];
    private String category = CATEGORY_DEFAULT_VALUE;
    private static final String CATEGORY_ENABLED_KEY = "categoryEnabled";
    private boolean categoryEnabled = false;
    private static final String SOURCES_KEY = "sources";
    private static final String SOURCES_DEFAULT_VALUE = null;
    private String sources = SOURCES_DEFAULT_VALUE;
    private static final String SOURCES_ENABLED_KEY = "sourcesEnabled";
    private boolean sourcesEnabled = false;
    private static final String Q_KEY = "q";
    private static final String Q_DEFAULT_VALUE = null;
    private String q = Q_DEFAULT_VALUE;
    private static final String Q_ENABLED_KEY = "qEnabled";
    private boolean qEnabled = false;
    private static final String PAGE_SIZE_KEY = "pageSize";
    static final Integer PAGE_SIZE_DEFAULT_VALUE = 100;
    static final Integer PAGE_SIZE_MINIMUM_VALUE = null;
    static final Integer PAGE_SIZE_MAXIMUM_VALUE = null;
    private int pageSize = PAGE_SIZE_DEFAULT_VALUE;
    private static final String PAGE_SIZE_ENABLED_KEY = "pageSizeEnabled";
    private boolean pageSizeEnabled = false;
    private static final String PAGE_KEY = "page";
    static final Integer PAGE_DEFAULT_VALUE = 1;
    static final Integer PAGE_MINIMUM_VALUE = null;
    static final Integer PAGE_MAXIMUM_VALUE = null;
    private int page = PAGE_DEFAULT_VALUE;
    private static final String PAGE_ENABLED_KEY = "pageEnabled";
    private boolean pageEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"articles\":{\"*\":{\"source\":{\"id\":\"rows[#3][0]\",\"name\":\"rows[#3][1]\"},\"author\":\"rows[#2][2]\",\"title\":\"rows[#2][3]\",\"description\":\"rows[#2][4]\",\"url\":\"rows[#2][5]\",\"urlToImage\":\"rows[#2][6]\",\"publishedAt\":\"rows[#2][7]\",\"content\":\"rows[#2][8]\"}}}}]").addBodyColumn(new DataColumnSpecCreator("Source ID", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Source Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Author", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Title", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Description", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("URL", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("URL to Image", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Published At", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Content", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    GetTopHeadlinesNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(COUNTRY_KEY, this.country);
        settings.addBoolean(COUNTRY_ENABLED_KEY, this.countryEnabled);
        settings.addString(CATEGORY_KEY, this.category);
        settings.addBoolean(CATEGORY_ENABLED_KEY, this.categoryEnabled);
        settings.addString(SOURCES_KEY, this.sources);
        settings.addBoolean(SOURCES_ENABLED_KEY, this.sourcesEnabled);
        settings.addString(Q_KEY, this.q);
        settings.addBoolean(Q_ENABLED_KEY, this.qEnabled);
        settings.addInt(PAGE_SIZE_KEY, this.pageSize);
        settings.addBoolean(PAGE_SIZE_ENABLED_KEY, this.pageSizeEnabled);
        settings.addInt(PAGE_KEY, this.page);
        settings.addBoolean(PAGE_ENABLED_KEY, this.pageEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.country = settings.getString(COUNTRY_KEY, COUNTRY_DEFAULT_VALUE);
        this.countryEnabled = settings.getBoolean(COUNTRY_ENABLED_KEY, false);
        this.category = settings.getString(CATEGORY_KEY, CATEGORY_DEFAULT_VALUE);
        this.categoryEnabled = settings.getBoolean(CATEGORY_ENABLED_KEY, false);
        this.sources = settings.getString(SOURCES_KEY, SOURCES_DEFAULT_VALUE);
        this.sourcesEnabled = settings.getBoolean(SOURCES_ENABLED_KEY, false);
        this.q = settings.getString(Q_KEY, Q_DEFAULT_VALUE);
        this.qEnabled = settings.getBoolean(Q_ENABLED_KEY, false);
        this.pageSize = settings.getInt(PAGE_SIZE_KEY, PAGE_SIZE_DEFAULT_VALUE.intValue());
        this.pageSizeEnabled = settings.getBoolean(PAGE_SIZE_ENABLED_KEY, false);
        this.page = settings.getInt(PAGE_KEY, PAGE_DEFAULT_VALUE.intValue());
        this.pageEnabled = settings.getBoolean(PAGE_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String country() {
        return this.country;
    }

    void country(String value) {
        this.country = value;
    }

    boolean countryEnabled() {
        return this.countryEnabled;
    }

    void countryEnabled(boolean value) {
        this.countryEnabled = value;
    }

    String category() {
        return this.category;
    }

    void category(String value) {
        this.category = value;
    }

    boolean categoryEnabled() {
        return this.categoryEnabled;
    }

    void categoryEnabled(boolean value) {
        this.categoryEnabled = value;
    }

    String sources() {
        return this.sources;
    }

    void sources(String value) {
        this.sources = value;
    }

    boolean sourcesEnabled() {
        return this.sourcesEnabled;
    }

    void sourcesEnabled(boolean value) {
        this.sourcesEnabled = value;
    }

    String q() {
        return this.q;
    }

    void q(String value) {
        this.q = value;
    }

    boolean qEnabled() {
        return this.qEnabled;
    }

    void qEnabled(boolean value) {
        this.qEnabled = value;
    }

    int pageSize() {
        return this.pageSize;
    }

    void pageSize(int value) {
        this.pageSize = value;
    }

    boolean pageSizeEnabled() {
        return this.pageSizeEnabled;
    }

    void pageSizeEnabled(boolean value) {
        this.pageSizeEnabled = value;
    }

    int page() {
        return this.page;
    }

    void page(int value) {
        this.page = value;
    }

    boolean pageEnabled() {
        return this.pageEnabled;
    }

    void pageEnabled(boolean value) {
        this.pageEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

