/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.explorer;

import com.nodepit.knime.explorer.WebDavContentProvider;
import com.nodepit.knime.explorer.utils.Logger;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.knime.core.workbench.mountpoint.api.WorkbenchMountPointSettings;
import org.knime.core.workbench.mountpoint.api.WorkbenchMountPointState;
import org.knime.core.workbench.mountpoint.api.WorkbenchMountTable;
import org.knime.workbench.explorer.ExplorerMountTable;
import org.knime.workbench.explorer.view.AbstractContentProvider;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin
implements IStartup {
    private static final Logger LOGGER = Logger.create(Activator.class);
    public static final String PLUGIN_ID = "com.nodepit.knime.explorer";
    private static final String PREF_DID_RUN_ADD_MOIN_POINT = "didRunAddMointPoint";
    private static final String DEFAULT_MOUNT_ID = "NodePit";
    private static final String FACTORY_ID = "com.nodepit.knime.explorer";
    private static Activator plugin;

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.addMointPointIfNotYetExists();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public void earlyStartup() {
    }

    public static Activator getDefault() {
        return plugin;
    }

    private void addMointPointIfNotYetExists() {
        IPreferenceStore prefStore = this.getPreferenceStore();
        boolean didRunAddMointPoint = prefStore.getBoolean(PREF_DID_RUN_ADD_MOIN_POINT);
        if (didRunAddMointPoint) {
            LOGGER.log("Mount point was already added before", new Object[0]);
            return;
        }
        Map mountedContent = ExplorerMountTable.getMountedContent();
        Optional<AbstractContentProvider> webDavMounts = mountedContent.values().stream().filter(WebDavContentProvider.class::isInstance).findAny();
        if (webDavMounts.isPresent()) {
            LOGGER.log("NodePit mount point already exists", new Object[0]);
        } else {
            try {
                WorkbenchMountPointSettings settings = new WorkbenchMountPointSettings(DEFAULT_MOUNT_ID, DEFAULT_MOUNT_ID, "com.nodepit.knime.explorer", WorkbenchMountPointState.EMPTY_SETTINGS, true);
                WorkbenchMountTable.mount((WorkbenchMountPointSettings)settings);
                WorkbenchMountTable.updateProviderSettings();
                LOGGER.log("Added NodePit mount point", new Object[0]);
            }
            catch (Exception e) {
                LOGGER.log("Error %s when trying to add NodePit mount point", e);
            }
        }
        prefStore.setValue(PREF_DID_RUN_ADD_MOIN_POINT, true);
    }
}

