/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.explorer.jobs;

import com.github.sardine.Sardine;
import com.nodepit.knime.explorer.WebDavFileStore;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.knime.workbench.explorer.filesystem.RemoteExplorerFileStore;

public final class MkDirJob
extends Job {
    private final WebDavFileStore target;
    private final Sardine sardine;

    public MkDirJob(WebDavFileStore target, Sardine sardine) {
        super("Creating directory on NodePit");
        this.target = Objects.requireNonNull(target);
        this.sardine = Objects.requireNonNull(sardine);
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.sardine.createDirectory(this.target.getWebDavUrl());
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (IOException e) {
            Status status = WebDavFileStore.makeStatus(String.format("Error while creating directory %s", this.target.getFullName()), e);
            return status;
        }
        finally {
            Display.getDefault().syncExec(() -> ((RemoteExplorerFileStore)this.target.getParent()).refresh());
        }
    }
}

