/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.explorer.jobs;

import com.github.sardine.Sardine;
import com.nodepit.knime.explorer.WebDavFileStore;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public final class MoveOrCopyJob
extends Job {
    private final WebDavFileStore source;
    private final WebDavFileStore destination;
    private final Operation operation;
    private final Sardine sardine;

    public MoveOrCopyJob(WebDavFileStore source, WebDavFileStore destination, Operation operation, Sardine sardine) {
        super("Move/copy item on NodePit");
        this.source = Objects.requireNonNull(source);
        this.destination = Objects.requireNonNull(destination);
        this.operation = Objects.requireNonNull(operation);
        this.sardine = Objects.requireNonNull(sardine);
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus iStatus;
        try {
            String sourceUrl = this.source.getWebDavUrl();
            String destinationUrl = this.destination.getWebDavUrl() + this.source.getExtension();
            if (this.operation == Operation.MOVE) {
                this.sardine.move(sourceUrl, destinationUrl);
            } else {
                this.sardine.copy(sourceUrl, destinationUrl);
            }
            iStatus = Status.OK_STATUS;
        }
        catch (IOException e) {
            Status status;
            try {
                status = WebDavFileStore.makeStatus(String.format("Error while moving/copying %s to %s", this.source.getFullName(), this.destination.getFullName()), e);
            }
            catch (Throwable throwable) {
                Display.getDefault().syncExec(() -> {
                    if (!Objects.equals(this.source.getParent(), this.destination.getParent())) {
                        this.destination.getParent().refresh();
                    }
                    this.source.getParent().refresh();
                });
                throw throwable;
            }
            Display.getDefault().syncExec(() -> {
                if (!Objects.equals(this.source.getParent(), this.destination.getParent())) {
                    this.destination.getParent().refresh();
                }
                this.source.getParent().refresh();
            });
            return status;
        }
        Display.getDefault().syncExec(() -> {
            if (!Objects.equals(this.source.getParent(), this.destination.getParent())) {
                this.destination.getParent().refresh();
            }
            this.source.getParent().refresh();
        });
        return iStatus;
    }

    public static enum Operation {
        MOVE,
        COPY;

    }
}

