/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.explorer.jobs;

import com.github.sardine.Sardine;
import com.nodepit.knime.explorer.WebDavFileStore;
import com.nodepit.knime.explorer.utils.ProgressMonitorUploadStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.knime.core.node.NodeLogger;
import org.knime.workbench.explorer.filesystem.AbstractExplorerFileInfo;
import org.knime.workbench.explorer.filesystem.AbstractExplorerFileStore;
import org.knime.workbench.explorer.filesystem.LocalExplorerFileStore;
import org.knime.workbench.explorer.view.AbstractContentProvider;
import org.knime.workbench.explorer.view.actions.export.WorkflowExporter;

public final class UploadJob
extends Job {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(UploadJob.class);
    private final LocalExplorerFileStore source;
    private final WebDavFileStore target;
    private final AbstractContentProvider.AfterRunCallback callback;
    private final boolean excludeDataInWorkflows;
    private final Sardine sardine;

    public UploadJob(LocalExplorerFileStore source, WebDavFileStore target, boolean excludeDataInWorkflows, AbstractContentProvider.AfterRunCallback callback, Sardine sardine) {
        super("Upload to NodePit");
        this.target = Objects.requireNonNull(target);
        this.source = Objects.requireNonNull(source);
        this.excludeDataInWorkflows = excludeDataInWorkflows;
        this.callback = callback;
        this.sardine = Objects.requireNonNull(sardine);
        this.setPriority(30);
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.processRecursively(this.source, this.target, monitor);
            this.callback(null);
            return Status.OK_STATUS;
        }
        catch (OperationCanceledException e) {
            this.callback(e);
            return Status.CANCEL_STATUS;
        }
        catch (IOException | CoreException e) {
            this.callback(e);
            return WebDavFileStore.makeStatus("Error during upload", e);
        }
    }

    private void processRecursively(LocalExplorerFileStore source, WebDavFileStore target, IProgressMonitor monitor) throws IOException, OperationCanceledException, CoreException {
        block7: {
            LOGGER.debugWithFormat("processRecursively(%s,%s,\u2026)", new Object[]{source, target});
            UploadJob.checkIfCancelled(monitor);
            File tempFile = null;
            try {
                AbstractExplorerFileInfo info = source.fetchInfo();
                if (info.isWorkflow() || info.isWorkflowTemplate()) {
                    tempFile = File.createTempFile("NodePitFile_" + source.getName(), null);
                    WorkflowExporter exporter = new WorkflowExporter(tempFile, (AbstractExplorerFileStore)source, Collections.singletonList(source), this.excludeDataInWorkflows);
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    exporter.doFinish((IProgressMonitor)subMonitor.split(25));
                    UploadJob.checkIfCancelled(monitor);
                    UploadJob.uploadFile(info, target, tempFile, (IProgressMonitor)subMonitor.split(75), this.sardine);
                    break block7;
                }
                if (info.isFile()) {
                    UploadJob.uploadFile(info, target, source.resolveToLocalFile(), monitor, this.sardine);
                    break block7;
                }
                if (info.isWorkflowGroup()) {
                    AbstractExplorerFileStore[] children = source.childStores(0, (IProgressMonitor)new NullProgressMonitor());
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(children.length + 1));
                    this.sardine.createDirectory(target.getWebDavUrl());
                    UploadJob.checkIfCancelled(monitor);
                    subMonitor.worked(1);
                    AbstractExplorerFileStore[] abstractExplorerFileStoreArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AbstractExplorerFileStore child = abstractExplorerFileStoreArray[n2];
                        LocalExplorerFileStore childStore = (LocalExplorerFileStore)child;
                        WebDavFileStore childTarget = (WebDavFileStore)target.getChild(childStore.getName());
                        this.processRecursively(childStore, childTarget, (IProgressMonitor)subMonitor.split(1));
                        ++n2;
                    }
                    break block7;
                }
                throw new UnsupportedOperationException("Uploading this type is currently not implemented");
            }
            finally {
                Optional.ofNullable(tempFile).ifPresent(File::delete);
            }
        }
    }

    private static void uploadFile(AbstractExplorerFileInfo sourceInfo, WebDavFileStore target, File file, IProgressMonitor monitor, Sardine sardine) throws FileNotFoundException, OperationCanceledException, IOException {
        Throwable throwable = null;
        Object var6_7 = null;
        try (ProgressMonitorUploadStream stream = new ProgressMonitorUploadStream(file, monitor);){
            String sourceExtension = WebDavFileStore.getExtension(sourceInfo);
            String targetUrl = WebDavFileStore.stripExtension(target.getWebDavUrl()) + sourceExtension;
            sardine.put(targetUrl, (InputStream)stream, null, true, file.length());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void checkIfCancelled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void callback(Throwable t) {
        Optional.ofNullable(this.callback).ifPresent(callback -> callback.afterCompletion(t));
    }
}

