/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.explorer.utils;

import com.nodepit.knime.explorer.utils.Logger;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionMonitor;

public final class ExecutorMonitorProgressAdapter
implements IProgressMonitor {
    private static final Logger LOGGER = Logger.create(ExecutorMonitorProgressAdapter.class);
    private final ExecutionMonitor monitor;
    private int totalWork;
    private int worked;

    public ExecutorMonitorProgressAdapter(ExecutionMonitor monitor) {
        this.monitor = Objects.requireNonNull(monitor, "monitor was null");
    }

    public void worked(int work) {
        this.worked += work;
        double progress = (double)this.worked / (double)this.totalWork;
        LOGGER.log("setProgress(%s)", progress);
        this.monitor.setProgress(progress);
    }

    public void subTask(String name) {
    }

    public void setTaskName(String name) {
    }

    public void setCanceled(boolean value) {
    }

    public boolean isCanceled() {
        try {
            this.monitor.checkCanceled();
            return false;
        }
        catch (CanceledExecutionException canceledExecutionException) {
            return true;
        }
    }

    public void internalWorked(double work) {
    }

    public void done() {
    }

    public void beginTask(String name, int totalWork) {
        this.totalWork = totalWork;
    }
}

