/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.nodes;

import com.nodepit.knime.nodes.ResponseMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import okhttp3.Response;
import org.knime.base.data.xml.SvgCellFactory;
import org.knime.core.data.DataCellFactory;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.DataType;
import org.knime.core.data.blob.BinaryObjectDataCell;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.IntCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.image.png.PNGImageCellFactory;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.data.xml.XMLCellFactory;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;

public final class SimpleResponseMapper
implements ResponseMapper {
    public static final String IDENTIFIER = "raw_response";
    private final DataColumnSpec[] headerSpecs;
    private final boolean withBody;

    private SimpleResponseMapper(DataColumnSpec[] headerSpecs, boolean withBody) {
        this.headerSpecs = headerSpecs;
        this.withBody = withBody;
    }

    @Override
    public BufferedDataTable getTable(ExecutionContext exec, Response response, String responseType) throws IOException {
        ArrayList<Object> cells = new ArrayList<Object>();
        if (this.withBody) {
            DataType bodyType = SimpleResponseMapper.getKnimeDataType(responseType);
            DataCellFactory cellFactory = (DataCellFactory)bodyType.getCellFactory(exec).orElseThrow(() -> new IllegalArgumentException("No cell factory"));
            if (!(cellFactory instanceof DataCellFactory.FromInputStream)) {
                throw new IllegalArgumentException("Cell factory does not support FromInputStream");
            }
            cells.add(((DataCellFactory.FromInputStream)cellFactory).createCell(response.body().byteStream()));
        }
        cells.add(new IntCell(response.code()));
        DataColumnSpec[] dataColumnSpecArray = this.headerSpecs;
        int n = this.headerSpecs.length;
        int n2 = 0;
        while (n2 < n) {
            DataColumnSpec headerSpec = dataColumnSpecArray[n2];
            DataCellFactory headerCellFactory = (DataCellFactory)headerSpec.getType().getCellFactory(exec).orElseThrow(() -> new IllegalArgumentException("No cell factory"));
            if (!(headerCellFactory instanceof DataCellFactory.FromString)) {
                throw new IllegalArgumentException("Cell factory does not support FromString");
            }
            DataCellFactory.FromString fromStringCellFactory = (DataCellFactory.FromString)headerCellFactory;
            cells.add(Optional.ofNullable(response.header(headerSpec.getName())).map(arg_0 -> ((DataCellFactory.FromString)fromStringCellFactory).createCell(arg_0)).orElse(DataType.getMissingCell()));
            ++n2;
        }
        BufferedDataContainer container = exec.createDataContainer(this.getSpec(responseType));
        container.addRowToTable((DataRow)new DefaultRow("Result", cells));
        container.close();
        return container.getTable();
    }

    @Override
    public DataTableSpec getSpec(String responseType) {
        DataTableSpecCreator specCreator = new DataTableSpecCreator();
        if (this.withBody) {
            specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("body", SimpleResponseMapper.getKnimeDataType(responseType)).createSpec()});
        }
        specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("status", IntCell.TYPE).createSpec()});
        specCreator.addColumns(this.headerSpecs);
        return specCreator.createSpec();
    }

    private static DataType getKnimeDataType(String mediaType) {
        if ("image/png".equals(mediaType)) {
            return PNGImageCellFactory.TYPE;
        }
        if ("image/svg+xml".equals(mediaType)) {
            return SvgCellFactory.TYPE;
        }
        if (mediaType.endsWith("xml")) {
            return XMLCellFactory.TYPE;
        }
        if (mediaType.endsWith("json")) {
            return JSONCellFactory.TYPE;
        }
        if (mediaType.startsWith("text/")) {
            return StringCell.StringCellFactory.TYPE;
        }
        return BinaryObjectDataCell.TYPE;
    }

    @Override
    public String label() {
        return "Raw Response";
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public boolean supportsResponseType(String responseType) {
        return true;
    }

    public static final class Builder {
        private final List<DataColumnSpec> headerColSpecs = new ArrayList<DataColumnSpec>();
        private boolean withBody = false;

        public Builder addHeaderColumn(DataColumnSpec spec) {
            this.headerColSpecs.add(spec);
            return this;
        }

        public Builder withBody() {
            this.withBody = true;
            return this;
        }

        public SimpleResponseMapper build() {
            return new SimpleResponseMapper((DataColumnSpec[])this.headerColSpecs.toArray(DataColumnSpec[]::new), this.withBody);
        }
    }
}

