/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.nodes.operation.getproducts;

import com.nodepit.knime.nodes.HttpRequestNodeParameters;
import com.nodepit.knime.nodes.NodeParametersUtils;
import com.nodepit.knime.nodes.ResponseMapper;
import com.nodepit.knime.nodes.SimpleResponseMapper;
import com.nodepit.knime.nodes.TransformToTableMapper;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.widget.choices.ChoicesProvider;

class GetProductsNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>NodePit ID:</b> Unique product identifier</li>\n\t<li><b>Name:</b> Human-readable name of the product</li>\n\t<li><b>URL:</b> NodePit URL of product page</li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetProductsNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"items\":{\"*\":{\"nodePitId\":\"rows[#2][0]\",\"name\":\"rows[#2][1]\",\"url\":\"rows[#2][2]\"}}}}]").addBodyColumn(new DataColumnSpecCreator("NodePit ID", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("URL", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    GetProductsNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class GetProductsNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetProductsNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

