/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.nodes.operation.search;

import com.nodepit.knime.nodes.HttpRequestNodeParameters;
import com.nodepit.knime.nodes.NodeParametersUtils;
import com.nodepit.knime.nodes.ResponseMapper;
import com.nodepit.knime.nodes.SimpleResponseMapper;
import com.nodepit.knime.nodes.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;
import org.knime.node.parameters.widget.number.NumberInputWidgetValidation;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class SearchNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Query", description="The query matching against the name\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String query = "barcode";
    @Widget(title="Set KNIME Version", description="Enable to set the optional field <b>KNIME Version</b>")
    @ValueReference(value=KnimeVersionEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean knimeVersionEnabled = false;
    @Widget(title="KNIME Version", description="KNIME version following <tt>major.minor</tt> format.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=KnimeVersionEnabledRef.class, type=Effect.EffectType.SHOW)
    String knimeVersion = "5.5";
    @Widget(title="Set Limit", description="Enable to set the optional field <b>Limit</b>")
    @ValueReference(value=LimitEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean limitEnabled = false;
    @Widget(title="Limit", description="Number of results to return\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=LimitEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget(minValidation=LimitMinValidation.class, maxValidation=LimitMaxValidation.class)
    int limit = 10;
    @Widget(title="Set Kind", description="Enable to set the optional field <b>Kind</b>")
    @ValueReference(value=KindEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean kindEnabled = false;
    @Widget(title="Kind", description="Specify the type(s) to search for\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=KindEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=KindPersistor.class)
    Kind[] kind = new Kind[]{new Kind(KIND_VALUES[0])};
    private static final String[] KIND_VALUES = new String[]{"node", "iu", "category", "workflow", "server", "port", "user", "product"};
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Name:</b> Human-readable name of the search result</li>\n\t<li><b>NodePit ID:</b> Type-specific identifier of the search result</li>\n\t<li><b>URL:</b> Nodepit URL with the search result</li>\n\t<li><b>Icon Src:</b> Image of the search result as <tt>data:</tt> URL which can be used as <tt>src</tt> in <tt>&lt;img&gt;</tt> elements.</li>\n\t<li><b>Kind:</b> The type of the search result</li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=SearchNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"items\":{\"*\":{\"name\":\"rows[#2][0]\",\"nodePitId\":\"rows[#2][1]\",\"url\":\"rows[#2][2]\",\"iconSrc\":\"rows[#2][3]\",\"kind\":\"rows[#2][4]\"}}}}]").addBodyColumn(new DataColumnSpecCreator("Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("NodePit ID", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("URL", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Icon Src", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Kind", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    SearchNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.query == null || this.query.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cQuery\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("query", this.query));
        if (this.knimeVersionEnabled) {
            params.add(new HttpRequestNodeParameters.Param("knimeVersion", this.knimeVersion));
        }
        if (this.limitEnabled) {
            params.add(new HttpRequestNodeParameters.Param("limit", this.limit));
        }
        if (this.kindEnabled) {
            Arrays.stream(this.kind).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("kind", value.text));
            });
        }
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    static final class Kind
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=KindChoicesProvider.class)
        String text;

        Kind() {
        }

        Kind(String text) {
            this.text = text;
        }

        private static final class KindChoicesProvider
        implements StringChoicesProvider {
            private KindChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(KIND_VALUES);
            }
        }
    }

    private static final class KindEnabledRef
    implements BooleanReference {
        private KindEnabledRef() {
        }
    }

    private static final class KindPersistor
    implements NodeParametersPersistor<Kind[]> {
        static final String CONFIG_KEY = "kind";

        private KindPersistor() {
        }

        public Kind[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Kind[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Kind::new).toArray(Kind[]::new);
        }

        public void save(Kind[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class KnimeVersionEnabledRef
    implements BooleanReference {
        private KnimeVersionEnabledRef() {
        }
    }

    private static final class LimitEnabledRef
    implements BooleanReference {
        private LimitEnabledRef() {
        }
    }

    private static final class LimitMaxValidation
    extends NumberInputWidgetValidation.MaxValidation {
        private LimitMaxValidation() {
        }

        public double getMax() {
            return 50.0;
        }
    }

    private static final class LimitMinValidation
    extends NumberInputWidgetValidation.MinValidation {
        private LimitMinValidation() {
        }

        public double getMin() {
            return 1.0;
        }
    }

    private static final class SearchNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private SearchNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

