/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.utils;

import com.google.gson.Gson;
import com.nodepit.knime.Activator;
import com.nodepit.knime.model.ExtensionInfo;
import com.nodepit.knime.model.NodeInfo;
import com.nodepit.knime.model.PluginConfiguration;
import com.nodepit.knime.model.WorkflowInfo;
import com.nodepit.knime.utils.UrlUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.Optional;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.eclipse.core.runtime.Platform;
import org.knime.core.node.KNIMEConstants;
import org.knime.core.node.NodeLogger;

public final class NodePitConnector {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(NodePitConnector.class);
    private static final Duration REACHABILITY_CHECK_TIMEOUT = Duration.ofSeconds(3L);
    private static final Duration REACHABILITY_CHECK_DEBOUNCE = Duration.ofSeconds(30L);
    private static long lastReachabilityCheck = 0L;
    private static boolean lastReachabilityResult = false;
    private static final String KNIME_MAJOR_MINOR = KNIMEConstants.MAJOR + "." + KNIMEConstants.MINOR;
    private static final Interceptor USER_AGENT_INTERCEPTOR = chain -> {
        Request request = chain.request().newBuilder().header("User-Agent", "com.nodepit.knime/2.12.4").build();
        return chain.proceed(request);
    };
    private static final OkHttpClient HTTP_CLIENT = new OkHttpClient.Builder().addInterceptor(USER_AGENT_INTERCEPTOR).build();

    private NodePitConnector() {
    }

    public static String getUrl() {
        return NodePitConnector.getConfig("nodePitUrl", "https://nodepit.com").replaceAll("/$", "");
    }

    public static Optional<String> getUserOptional() {
        return Optional.ofNullable(NodePitConnector.getConfig("personalNodePitUsername", null));
    }

    public static Optional<String> getPasswordOptional() {
        return Optional.ofNullable(NodePitConnector.getConfig("personalNodePitPassword", null));
    }

    private static String getConfig(String cfgKey, String defaultValue) {
        String value;
        if (Activator.getDefault() != null && (value = Activator.getDefault().getPreferenceStore().getString(cfgKey)) != null && !value.isEmpty()) {
            return value;
        }
        return defaultValue;
    }

    public static String getNodeUrl(String nodeId) {
        return NodePitConnector.getEncodedUrl(String.format(NodePitConnector.getUrl() + "/node/%s", nodeId));
    }

    public static String getCategoryUrl(String categoryId) {
        return NodePitConnector.getEncodedUrl(String.format(NodePitConnector.getUrl() + "/category/%s", categoryId));
    }

    public static PluginConfiguration getPluginConfiguration() throws IOException {
        String url = NodePitConnector.getUrl() + String.format("/api/plugin/configuration?knimeVersion=%s&os=%s&knimeId=%s&knimeNightly=%s&pluginVersion=%s&arch=%s", KNIMEConstants.VERSION, UrlUtils.urlEncode(KNIMEConstants.getOSVariant()), KNIMEConstants.getKNIMEInstanceID(), KNIMEConstants.isNightlyBuild(), Activator.getBundleVersion(), Platform.getOSArch());
        Request.Builder builder = new Request.Builder().url(url);
        if (NodePitConnector.getUserOptional().isPresent() && NodePitConnector.getPasswordOptional().isPresent()) {
            builder.header("Authorization", Credentials.basic((String)NodePitConnector.getUserOptional().get(), (String)NodePitConnector.getPasswordOptional().get()));
        }
        String configuration = HTTP_CLIENT.newCall(builder.build()).execute().body().string();
        return (PluginConfiguration)new Gson().fromJson(configuration, PluginConfiguration.class);
    }

    public static NodeInfo getNodeInfo(String nodePitId) throws IOException {
        String url = NodePitConnector.getUrl() + String.format("/api/%s/nodes/%s", KNIME_MAJOR_MINOR, nodePitId);
        String nodeInfo = HTTP_CLIENT.newCall(new Request.Builder().url(url).build()).execute().body().string();
        return (NodeInfo)new Gson().fromJson(nodeInfo, NodeInfo.class);
    }

    public static ExtensionInfo getExtensionInfo(String nodePitId) throws IOException {
        String url = NodePitConnector.getUrl() + String.format("/api/%s/features/%s", KNIME_MAJOR_MINOR, nodePitId);
        String nodeInfo = HTTP_CLIENT.newCall(new Request.Builder().url(url).build()).execute().body().string();
        return (ExtensionInfo)new Gson().fromJson(nodeInfo, ExtensionInfo.class);
    }

    public static WorkflowInfo getWorkflowInfo(String nodePitId) throws IOException {
        String url = NodePitConnector.getUrl() + String.format("/api/workflows/%s", nodePitId.replace("/", "%2F"));
        String workflowInfo = HTTP_CLIENT.newCall(new Request.Builder().url(url).build()).execute().body().string();
        return (WorkflowInfo)new Gson().fromJson(workflowInfo, WorkflowInfo.class);
    }

    public static boolean isNodePitReachable() {
        long now = System.currentTimeMillis();
        if (now - lastReachabilityCheck < REACHABILITY_CHECK_DEBOUNCE.toMillis() && lastReachabilityResult) {
            LOGGER.debug((Object)"NodePit reachability check debounced");
            return lastReachabilityResult;
        }
        lastReachabilityResult = NodePitConnector.checkNodePitReachable();
        lastReachabilityCheck = now;
        return lastReachabilityResult;
    }

    private static boolean checkNodePitReachable() {
        Response head;
        block3: {
            try {
                head = new OkHttpClient().newBuilder().addInterceptor(USER_AGENT_INTERCEPTOR).connectTimeout(REACHABILITY_CHECK_TIMEOUT).readTimeout(REACHABILITY_CHECK_TIMEOUT).writeTimeout(REACHABILITY_CHECK_TIMEOUT).build().newCall(new Request.Builder().url(NodePitConnector.getUrl()).head().build()).execute();
                if (!head.isSuccessful()) break block3;
                LOGGER.debug((Object)"NodePit reachability check success");
                return true;
            }
            catch (Exception e) {
                LOGGER.debug((Object)String.format("NodePit doesn't seem to be reachable: %s", NodePitConnector.getUrl()), (Throwable)e);
                return false;
            }
        }
        LOGGER.debugWithFormat("Encountered HTTP status %s when checking NodePit reachability", new Object[]{head.code()});
        return false;
    }

    private static String getEncodedUrl(String urlToEncode) {
        try {
            URL url = new URL(urlToEncode);
            URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            return uri.toURL().toString().replaceAll("#", "%23");
        }
        catch (Exception exception) {
            LOGGER.warnWithFormat("Error while encoding url: %s", new Object[]{urlToEncode});
            return urlToEncode;
        }
    }
}

