/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public final class UrlUtils {
    public static String urlEncode(String name) {
        Objects.requireNonNull(name, "name was null");
        try {
            return URLEncoder.encode(name, "utf8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("utf8 encoding not supported", e);
        }
    }

    public static String urlEncodePathComponents(String path) {
        Objects.requireNonNull(path, "path was null");
        return Arrays.stream(path.split("/", -1)).map(UrlUtils::urlEncode).collect(Collectors.joining("/"));
    }

    private UrlUtils() {
    }
}

