/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.view;

import com.nodepit.knime.Configuration;
import com.nodepit.knime.model.Selection;
import com.nodepit.knime.utils.KnimeHelper;
import com.nodepit.knime.utils.NodePitConnector;
import com.nodepit.knime.utils.NodePitUrlParser;
import com.nodepit.knime.view.NodePitBrowser;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.knime.core.internal.ReferencedFile;
import org.knime.core.node.NodeFactory;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.workflow.NativeNodeContainer;
import org.knime.core.node.workflow.NodeContainer;
import org.knime.core.ui.node.workflow.NodeContainerUI;
import org.knime.core.ui.wrapper.NodeContainerWrapper;
import org.knime.workbench.editor2.editparts.NodeContainerEditPart;
import org.knime.workbench.repository.model.Category;
import org.knime.workbench.repository.model.NodeTemplate;

public class NodePitView
extends ViewPart
implements ISelectionListener,
LocationListener,
IPropertyChangeListener {
    public static final String ID = "com.nodepit.knime.view.nodepit";
    public static final String NODEPIT_VIEW_LINK_CFG_KEY = "nodePitViewLink";
    public static final boolean NODEPIT_VIEW_LINK_DEFAULT = false;
    private static final NodeLogger LOGGER = NodeLogger.getLogger(NodePitView.class);
    private static final String OFFLINE_PAGE_LOCATION = "about:blank";
    private NodePitBrowser nodepitBrowser;
    public boolean isOffline = false;

    public void createPartControl(Composite parent) {
        this.nodepitBrowser = new NodePitBrowser(parent, 0);
        Configuration.addPropertyChangeListener(this);
        this.nodepitBrowser.addLocationListener(this);
        this.getViewSite().getPage().addSelectionListener((ISelectionListener)this);
    }

    public void setFocus() {
        if (this.nodepitBrowser != null) {
            this.nodepitBrowser.focus();
        }
    }

    public void dispose() {
        Configuration.removePropertyChangeListener(this);
        this.getViewSite().getPage().removeSelectionListener((ISelectionListener)this);
        if (this.nodepitBrowser != null) {
            this.nodepitBrowser.dispose();
            this.nodepitBrowser = null;
            super.dispose();
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.nodepitBrowser == null) {
            return;
        }
        if (this.nodepitBrowser != null && this.nodepitBrowser.isDisposed()) {
            this.getViewSite().getPage().removeSelectionListener((ISelectionListener)this);
            return;
        }
        TreeSet<Selection> selectedItems = new TreeSet<Selection>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object sel : structuredSelection) {
                if (sel instanceof NodeContainerEditPart) {
                    NodeContainerWrapper nodeContainerWrapper;
                    NodeContainer nodeContainer;
                    NodeContainerUI nodeContainerUI = ((NodeContainerEditPart)sel).getNodeContainer();
                    if (!(nodeContainerUI instanceof NodeContainerWrapper) || !((nodeContainer = (NodeContainer)(nodeContainerWrapper = (NodeContainerWrapper)nodeContainerUI).unwrap()) instanceof NativeNodeContainer)) continue;
                    NativeNodeContainer nativeNodeContainer = (NativeNodeContainer)nodeContainer;
                    NodeFactory nodeFactory = nativeNodeContainer.getNode().getFactory();
                    if (nodeFactory.getType() != NodeFactory.NodeType.Missing) {
                        String factoryID2 = nodeFactory.getClass().getName();
                        selectedItems.add(new Selection(factoryID2, nodeContainer.getName(), Selection.Type.NODE));
                        continue;
                    }
                    NodePitView.tryParseFactoryFromSettings(nativeNodeContainer.getNodeContainerDirectory()).ifPresent(factoryID -> {
                        boolean bl = selectedItems.add(new Selection((String)factoryID, nodeContainer.getName().replaceAll("^MISSING\\s+", ""), Selection.Type.NODE));
                    });
                    continue;
                }
                if (sel instanceof NodeTemplate) {
                    NodeTemplate templ = (NodeTemplate)sel;
                    selectedItems.add(new Selection(templ.getID(), templ.getName(), Selection.Type.NODE));
                    continue;
                }
                if (!(sel instanceof Category)) continue;
                Category category = (Category)sel;
                ArrayList<String> categoryPath = new ArrayList<String>();
                Category next = category;
                while (next != null && !next.getID().equals("/")) {
                    categoryPath.add(next.getID());
                    next = next.getParent();
                }
                Collections.reverse(categoryPath);
                String categoryPathID = String.join((CharSequence)"/", categoryPath);
                if (categoryPathID.equals("uncategorized")) {
                    categoryPathID = "";
                }
                selectedItems.add(new Selection(categoryPathID, category.getName(), Selection.Type.CATEGORY));
            }
        }
        if (selectedItems.isEmpty()) {
            return;
        }
        this.nodepitBrowser.setSelection(selectedItems);
    }

    private static Optional<String> tryParseFactoryFromSettings(ReferencedFile nodeContainerDir) {
        File pathToSettings = new File(nodeContainerDir.getFile().getAbsolutePath(), "settings.xml");
        try {
            String xmlContent = Files.readString(pathToSettings.toPath(), StandardCharsets.UTF_8);
            Pattern pattern = Pattern.compile("<entry key=\"factory\" type=\"xstring\" value=\"([^\"]*)\"\\/>");
            Matcher matcher = pattern.matcher(xmlContent);
            if (matcher.find()) {
                return Optional.of(matcher.group(1));
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)("Could not extract factory information from " + String.valueOf(pathToSettings)), (Throwable)e);
        }
        return Optional.empty();
    }

    public void changing(LocationEvent event) {
        if (event.location.matches("nodepit://reconnect(\\?.*)?")) {
            event.doit = false;
            this.isOffline = false;
            this.nodepitBrowser.goHome();
        } else if (this.isOffline) {
            event.doit = false;
        } else if (!OFFLINE_PAGE_LOCATION.equals(event.location) && !NodePitConnector.isNodePitReachable()) {
            event.doit = false;
            this.nodepitBrowser.showPlaceholderPage();
            this.isOffline = true;
        } else if (event.location.startsWith("nodepit://")) {
            event.doit = false;
            this.installFeatureFromNodePitUrl(event.location);
        } else if (NodePitView.isLeavingNodePit(event)) {
            event.doit = false;
            NodePitView.openInExternalBrowser(event);
        }
    }

    private static void openInExternalBrowser(LocationEvent event) {
        try {
            URL url = new URL(event.location);
            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(url);
        }
        catch (PartInitException e) {
            throw new IllegalStateException("Could not get external browser.", e);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Malformed URL: " + event.location, e);
        }
    }

    private static boolean isLeavingNodePit(LocationEvent event) {
        return !event.location.startsWith(NodePitConnector.getUrl()) && !OFFLINE_PAGE_LOCATION.equals(event.location);
    }

    public void changed(LocationEvent event) {
    }

    private void installFeatureFromNodePitUrl(String nodePitUrl) {
        List<String> featureIds;
        String updateSiteUrl;
        List<String> dependencyUpdateSiteUrls = Collections.emptyList();
        try {
            NodePitUrlParser.NodePitUrl parsedUrl = NodePitUrlParser.parseUrl(nodePitUrl);
            if (!"install".equals(parsedUrl.actionName)) {
                throw new IllegalArgumentException("Invalid action name; expected 'install' instead of '" + parsedUrl.actionName + "'.");
            }
            updateSiteUrl = parsedUrl.getParameter("updateSiteUrl");
            if (updateSiteUrl == null) {
                throw new IllegalArgumentException("updateSiteUrl was missing!");
            }
            String featureIdsString = parsedUrl.getParameter("featureIds");
            if (featureIdsString == null) {
                throw new IllegalArgumentException("featureIds was missing!");
            }
            featureIds = Arrays.asList(featureIdsString.split(","));
            String dependencyUrlsString = parsedUrl.getParameter("dependencyUrls");
            if (dependencyUrlsString != null) {
                dependencyUpdateSiteUrls = Arrays.asList(dependencyUrlsString.split(","));
            }
        }
        catch (Exception e) {
            this.openErrorDialog("Invalid NodePit URL", e);
            return;
        }
        try {
            if (!KnimeHelper.isFeaturesInstalled(featureIds)) {
                KnimeHelper.openInstallDialog(updateSiteUrl, featureIds, dependencyUpdateSiteUrls);
            } else {
                this.openAlreadyInstalledDialog();
            }
        }
        catch (Exception e) {
            Object message = updateSiteUrl == null ? "We were not able to install this node. Please install it manually (\u201cHelp -> Install new software\u2026\u201d) using the update site displayed on NodePit." : "We were not able to install this node. Please install it manually (\u201cHelp -> Install new software\u2026\u201d) using the following update site: " + updateSiteUrl;
            this.openErrorDialog((String)message, e);
        }
    }

    private void openAlreadyInstalledDialog() {
        String message = "This node is already installed. Please check your node repository.";
        MessageDialog.openInformation((Shell)this.getSite().getWorkbenchWindow().getShell(), (String)"Info", (String)message);
    }

    private void openErrorDialog(String message, Throwable t) {
        List<Status> statuses = Arrays.stream(t.getStackTrace()).map(element -> new Status(4, "com.nodepit.knime.plugin", element.toString())).collect(Collectors.toList());
        MultiStatus status = new MultiStatus("com.nodepit.knime.plugin", 4, (IStatus[])statuses.toArray(new Status[0]), t.toString(), t);
        ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)message, (IStatus)status);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.nodepitBrowser != null && "nodePitUrl".equals(event.getProperty())) {
            this.nodepitBrowser.goHome();
        }
    }
}

