/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime;

import com.nodepit.knime.Configuration;
import com.nodepit.knime.OpenViewJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class Activator
extends AbstractUIPlugin
implements IStartup {
    public static final String PLUGIN_ID = "com.nodepit.knime.plugin";
    private static final String LAST_ACTIVATED_PREF_NAME = "lastNodePitVersionActivated";
    private static Activator plugin;

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Configuration.updatePluginConfiguration();
        Configuration.addPropertyChangeListener(event -> {
            if ("nodePitUrl".equals(event.getProperty())) {
                Configuration.updatePluginConfiguration();
            }
        });
        if (this.shouldOpenNodePitView()) {
            this.openNodePitView();
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static String getBundleVersion() {
        String bundleVersion = (String)Platform.getBundle((String)PLUGIN_ID).getHeaders().get("Bundle-Version");
        return bundleVersion != null ? bundleVersion : "<unknown>";
    }

    private boolean shouldOpenNodePitView() {
        Version version = Activator.getDefault().getBundle().getVersion();
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        String lastVersionActivated = preferenceStore.getString(LAST_ACTIVATED_PREF_NAME);
        boolean shouldOpenView = "".equals(lastVersionActivated);
        preferenceStore.setValue(LAST_ACTIVATED_PREF_NAME, version.toString());
        return shouldOpenView;
    }

    private void openNodePitView() {
        new OpenViewJob("Open NodePit view").run((IProgressMonitor)new NullProgressMonitor());
    }

    public void earlyStartup() {
    }
}

