/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.model;

import com.nodepit.knime.utils.NodePitConnector;
import java.util.Objects;
import java.util.function.Function;

public class Selection
implements Comparable<Selection> {
    private final String identifier;
    private final String name;
    private final Type type;

    public Selection(String identifier, String name, Type type) {
        this.identifier = identifier;
        this.name = name;
        this.type = Objects.requireNonNull(type);
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.type.getUrl(this.identifier);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Selection other = (Selection)obj;
        return Objects.equals(this.identifier, other.identifier) && this.type == other.type;
    }

    @Override
    public int compareTo(Selection o) {
        return this.getName().compareTo(o.getName());
    }

    public String toString() {
        return "Selection [name=" + this.getName() + ", url=" + this.getUrl() + "]";
    }

    public static enum Type {
        NODE(NodePitConnector::getNodeUrl),
        CATEGORY(NodePitConnector::getCategoryUrl);

        private final Function<String, String> urlGetter;

        private Type(Function<String, String> urlGetter) {
            this.urlGetter = urlGetter;
        }

        String getUrl(String identifier) {
            return this.urlGetter.apply(identifier);
        }
    }
}

