/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.preference;

import com.nodepit.knime.Configuration;
import com.nodepit.knime.utils.NodePitConnector;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SwtUserAgentRetriever
extends StringButtonFieldEditor {
    public SwtUserAgentRetriever(Composite parent) {
        super("user_agent", "Browser info (read only)", parent);
        if (Configuration.shouldDisableSwtBrowserJS()) {
            this.setEnabled(false, parent);
            this.setStringValue("JS disabled due to macOS/Intel bug");
        } else {
            this.setStringValue("Click \u201cGet \u2026\u201d to get SWT browser debugging info");
        }
        this.setChangeButtonText("Get \u2026");
        this.getTextControl(parent).setEditable(false);
    }

    protected String changePressed() {
        final Shell shell = new Shell(Display.getDefault());
        shell.setLayout((Layout)new FillLayout());
        final Browser browser = new Browser((Composite)shell, 0);
        browser.addProgressListener(new ProgressListener(){

            public void completed(ProgressEvent event) {
                String userAgent = (String)browser.evaluate("return navigator.userAgent");
                SwtUserAgentRetriever.this.setStringValue(userAgent);
                shell.dispose();
            }

            public void changed(ProgressEvent event) {
                SwtUserAgentRetriever.this.setStringValue("Loading, gimme a second or two \u2026");
            }
        });
        browser.setUrl(NodePitConnector.getUrl());
        shell.pack();
        shell.open();
        return null;
    }

    protected void doLoad() {
    }

    protected void doStore() {
    }
}

