/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.view;

import com.nodepit.knime.Activator;
import com.nodepit.knime.Configuration;
import com.nodepit.knime.model.Selection;
import com.nodepit.knime.utils.Images;
import com.nodepit.knime.utils.KnimeHelper;
import com.nodepit.knime.utils.NodePitConnector;
import com.nodepit.knime.utils.UrlUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.knime.core.node.NodeLogger;

public class NodePitBrowser
extends Composite {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(NodePitBrowser.class);
    private static String PLACEHOLDER_PAGE_CONTENT;
    private Browser browser;
    private ToolBar selectionBar;

    static {
        try {
            Throwable throwable = null;
            Object var1_2 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(NodePitBrowser.class.getResourceAsStream("offline.html"), StandardCharsets.UTF_8));){
                PLACEHOLDER_PAGE_CONTENT = reader.lines().collect(Collectors.joining("\n"));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Unable to load placeholder page. Use fallback page instead.");
            PLACEHOLDER_PAGE_CONTENT = "<html><head><title>NodePit</title></head><body><h1>NodePit is currently not reachable. Check your Internet connection.</h1></body></html>";
        }
    }

    public NodePitBrowser(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FormLayout());
        try {
            this.browser = new Browser((Composite)this, 2048);
            if (Configuration.shouldDisableSwtBrowserJS()) {
                this.browser.setJavascriptEnabled(false);
            }
        }
        catch (SWTError sWTError) {
            parent.setLayout((Layout)new FillLayout());
            Label label = new Label(parent, 0x1000040);
            label.setText("Error: NodePit could not be started. Sorry.");
            parent.layout(true);
            return;
        }
        ToolBar menuBar = new ToolBar((Composite)this, 0);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        menuBar.setLayoutData((Object)data);
        final ToolItem itemBack = new ToolItem(menuBar, 8);
        itemBack.setText("\u2190");
        itemBack.setEnabled(this.browser.isBackEnabled());
        itemBack.addListener(13, event -> {
            boolean bl = this.browser.back();
        });
        ToolItem itemHome = new ToolItem(menuBar, 8);
        itemHome.setText("NodePit");
        itemHome.addListener(13, event -> this.goHome());
        final ToolItem itemForward = new ToolItem(menuBar, 8);
        itemForward.setText("\u2192");
        itemForward.setEnabled(this.browser.isForwardEnabled());
        itemForward.addListener(13, event -> {
            boolean bl = this.browser.forward();
        });
        ToolItem separator = new ToolItem(menuBar, 2);
        separator.setWidth(0);
        ToolItem itemLink = new ToolItem(menuBar, 32);
        itemLink.setImage(Images.LINK_IMAGE_16PX);
        itemLink.setToolTipText("Automatically update on selection");
        itemLink.setSelection(Activator.getDefault().getPreferenceStore().getBoolean("nodePitViewLink"));
        itemLink.addListener(13, event -> {
            ToolItem itemLink1 = (ToolItem)event.widget;
            Activator.getDefault().getPreferenceStore().setValue("nodePitViewLink", itemLink1.getSelection());
            if (itemLink1.getSelection() && this.selectionBar.getItemCount() > 0) {
                this.selectionBar.getItem(0).notifyListeners(13, new Event());
            }
        });
        menuBar.pack();
        int itemsWidth = itemBack.getWidth() + itemHome.getWidth() + itemForward.getWidth() + itemLink.getWidth();
        int trimWidth = menuBar.getSize().x - itemsWidth;
        menuBar.addListener(11, event -> {
            int itemsWidth1 = itemBack.getWidth() + itemHome.getWidth() + itemForward.getWidth() + itemLink.getWidth();
            separator.setWidth(toolBar.getSize().x - itemsWidth1 - trimWidth);
        });
        this.selectionBar = new ToolBar((Composite)this, 0);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.selectionBar.setLayoutData((Object)data);
        ToolItem loveNodes = new ToolItem(this.selectionBar, 8);
        loveNodes.setText("NodePit: Because we \u2764 Nodes");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)menuBar);
        data.bottom = new FormAttachment((Control)this.selectionBar);
        this.browser.setLayoutData((Object)data);
        this.browser.addProgressListener((ProgressListener)new ProgressAdapter(){

            public void completed(ProgressEvent event) {
                itemBack.setEnabled(NodePitBrowser.this.browser.isBackEnabled());
                itemForward.setEnabled(NodePitBrowser.this.browser.isForwardEnabled());
            }
        });
        this.browser.addOpenWindowListener(event -> {
            if (event.required) {
                event.browser = this.browser;
            }
        });
        this.goHome();
    }

    public void focus() {
        this.browser.setFocus();
    }

    public void goHome() {
        String pluginStr = String.format("NodePit-Plugin/%s", Activator.getBundleVersion());
        this.setUrl(String.format(NodePitConnector.getUrl() + "?knime-version=%s&nodepit-plugin=%s", UrlUtils.urlEncode(KnimeHelper.getKnimeVersion()), UrlUtils.urlEncode(pluginStr)));
    }

    private void setUrl(String url) {
        if (this.browser != null && !this.browser.getUrl().equals(url)) {
            LOGGER.debugWithFormat("Open url in browser: %s", new Object[]{url});
            this.browser.setUrl(url, null, null);
        }
    }

    public void showPlaceholderPage() {
        if (this.browser != null) {
            LOGGER.debug((Object)"NodePit is not reachable. Show placeholder page in browser");
            this.browser.setText(PLACEHOLDER_PAGE_CONTENT);
        }
    }

    public void setSelection(Set<Selection> selectedItems) {
        Arrays.stream(this.selectionBar.getItems()).forEach(i -> i.dispose());
        selectedItems.forEach(node -> {
            ToolItem itemNodeSelection = new ToolItem(this.selectionBar, 8);
            itemNodeSelection.setText(node.getName());
            itemNodeSelection.addListener(13, event -> this.setUrl(node.getUrl()));
            this.selectionBar.getParent().layout(true);
        });
        if (this.selectionBar.getItemCount() == 0) {
            ToolItem loveNodes = new ToolItem(this.selectionBar, 8);
            loveNodes.setText("NodePit: Because we \u2764 Nodes");
        }
        if (!selectedItems.isEmpty() && Activator.getDefault().getPreferenceStore().getBoolean("nodePitViewLink")) {
            this.setUrl(selectedItems.iterator().next().getUrl());
        }
    }

    public void addLocationListener(LocationListener listener) {
        this.browser.addLocationListener(listener);
    }

    public static void main(String[] args) throws IOException {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        shell.setText("NodePit Browser");
        new NodePitBrowser((Composite)shell, 0);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

