/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.explorer;

import com.github.sardine.Sardine;
import com.github.sardine.impl.SardineImpl;
import com.nodepit.knime.explorer.WebDavFileStoreConfig;
import com.nodepit.knime.explorer.utils.LoggingSardine;
import com.nodepit.knime.utils.NodePitConnector;
import com.nodepit.knime.utils.StringUtils;
import java.net.MalformedURLException;
import java.net.ProxySelector;
import java.net.URL;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.HttpClientBuilder;

final class WebDavFileStoreConfigSource {
    private static final int TIMEOUT_MS = 3000;

    public static WebDavFileStoreConfig getConfig() {
        return new WebDavFileStoreConfig(){

            @Override
            public String getUser() {
                return (String)NodePitConnector.getUserOptional().orElseThrow(() -> new IllegalArgumentException("NodePit username is missing; check NodePit preferences."));
            }

            @Override
            public Sardine getSardine() {
                URL parsedUrl;
                String user = this.getUser().toLowerCase();
                String password = (String)NodePitConnector.getPasswordOptional().orElseThrow(() -> new IllegalArgumentException("NodePit password is missing; check NodePit preferences."));
                String url = this.getNodePitUrl();
                try {
                    parsedUrl = new URL(url);
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(String.format("NodePit URL '%s' is not valid; check NodePit preferences.", url), e);
                }
                SardineImpl sardine = new SardineImpl(user, password){

                    protected HttpClientBuilder configure(ProxySelector selector, CredentialsProvider credentials) {
                        return super.configure(selector, credentials).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(3000).setSocketTimeout(3000).build()).setUserAgent("com.nodepit.knime/2.12.3");
                    }
                };
                sardine.enableCompression();
                sardine.enablePreemptiveAuthentication(parsedUrl);
                return new LoggingSardine((Sardine)sardine);
            }

            @Override
            public String getNodePitUrl() {
                return StringUtils.requireNonEmpty((String)NodePitConnector.getUrl(), (String)"NodePit URL is missing; check NodePit preferences.");
            }
        };
    }

    private WebDavFileStoreConfigSource() {
    }
}

