/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.explorer;

import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import com.github.sardine.impl.SardineException;
import com.nodepit.knime.explorer.WebDavFileStore;
import com.nodepit.knime.explorer.WebDavFileStoreConfig;
import com.nodepit.knime.explorer.utils.ExecutorMonitorProgressAdapter;
import com.nodepit.knime.explorer.utils.Logger;
import com.nodepit.knime.explorer.utils.NoOpAuthenticator;
import com.nodepit.knime.explorer.utils.ProgressMonitorDownloadStream;
import com.nodepit.knime.explorer.utils.ProgressMonitorUploadStream;
import com.nodepit.knime.explorer.utils.ZipUtil;
import com.nodepit.knime.utils.NodePitConstants;
import com.nodepit.knime.utils.UrlUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.PlatformUI;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.workflow.WorkflowCreationHelper;
import org.knime.core.node.workflow.WorkflowManager;
import org.knime.core.node.workflow.contextv2.HubSpaceLocationInfo;
import org.knime.core.node.workflow.contextv2.HubSpaceLocationInfoBuilderFactory;
import org.knime.core.node.workflow.contextv2.LocationInfo;
import org.knime.core.node.workflow.contextv2.WorkflowContextV2;
import org.knime.core.util.FileUtil;
import org.knime.core.util.LockFailedException;
import org.knime.core.util.auth.Authenticator;
import org.knime.core.util.exception.ResourceAccessException;
import org.knime.gateway.api.util.VersionId;
import org.knime.gateway.api.webui.entity.SpaceEnt;
import org.knime.gateway.api.webui.entity.SpaceItemEnt;
import org.knime.gateway.api.webui.entity.SpaceItemReferenceEnt;
import org.knime.gateway.api.webui.entity.SpacePathSegmentEnt;
import org.knime.gateway.api.webui.entity.WorkflowGroupContentEnt;
import org.knime.gateway.api.webui.service.util.ServiceExceptions;
import org.knime.gateway.api.webui.util.EntityFactory;
import org.knime.gateway.impl.webui.entity.DefaultSpaceItemEnt;
import org.knime.gateway.impl.webui.entity.DefaultSpacePathSegmentEnt;
import org.knime.gateway.impl.webui.entity.DefaultWorkflowGroupContentEnt;
import org.knime.gateway.impl.webui.spaces.Space;
import org.knime.gateway.impl.webui.spaces.local.LocalSpace;

class WebDavSpace
implements Space {
    private static final Logger LOGGER = Logger.create(WebDavSpace.class);
    private static final String TEMP_PREFIX = "NodePit_";
    private static final int CONFLICT_MAX_ATTEMPTS = 25;
    private final String mountID;
    private final WebDavFileStoreConfig config;
    private final Type type;

    WebDavSpace(String mountID, WebDavFileStoreConfig config, Type type) {
        this.mountID = Objects.requireNonNull(mountID, "mountID was null");
        this.config = Objects.requireNonNull(config, "config was null");
        this.type = Objects.requireNonNull(type, "type was null");
    }

    public String getId() {
        return this.type.id;
    }

    public String getName() {
        return this.type.name;
    }

    public WorkflowGroupContentEnt listWorkflowGroup(String workflowGroupItemId) throws IOException {
        LOGGER.log("listWorkflowGroup(%s)", workflowGroupItemId);
        String tempWorkflowId = this.replaceRootPlaceholder(workflowGroupItemId);
        List<SpaceItemEnt> items = this.config.getSardine().list(this.config.getNodePitUrl() + UrlUtils.urlEncodePathComponents((String)tempWorkflowId)).stream().skip(1L).filter(file -> !this.isIgnored((DavResource)file)).map(WebDavSpace::mapFile).sorted(ITEM_COMPARATOR).toList();
        return new DefaultWorkflowGroupContentEnt.DefaultWorkflowGroupContentEntBuilder().setItems(items).setPath(WebDavSpace.buildPath(workflowGroupItemId, this.type.prefix)).build();
    }

    public SpaceItemEnt createWorkflow(String workflowGroupItemId, String workflowName) throws IOException {
        LOGGER.log("createWorkflow(%s,%s)", workflowGroupItemId, workflowName);
        File tempDir = FileUtil.createTempDir((String)TEMP_PREFIX);
        try {
            String workflowFileName = workflowName + ".knwf";
            File workflow = new File(tempDir, workflowFileName);
            WebDavSpace.createEmptyWorkflow(workflowName, workflow);
            String replacedWorkflowGroupItemId = this.replaceRootPlaceholder(workflowGroupItemId);
            DefaultSpaceItemEnt defaultSpaceItemEnt = this.importFileOrWorkflow(workflow.toPath(), replacedWorkflowGroupItemId, SpaceItemEnt.TypeEnum.WORKFLOW, Space.NameCollisionHandling.NOOP, (IProgressMonitor)new NullProgressMonitor());
            return defaultSpaceItemEnt;
        }
        finally {
            FileUtil.deleteRecursively((File)tempDir);
        }
    }

    public SpaceItemEnt createWorkflowGroup(String workflowGroupItemId) throws IOException {
        LOGGER.log("createWorkflowGroup(%s)", workflowGroupItemId);
        String path = this.replaceRootPlaceholder(workflowGroupItemId);
        Sardine sardine = this.config.getSardine();
        int attempt = 0;
        while (true) {
            try {
                String newPath = path + "Folder";
                if (attempt > 0) {
                    newPath = newPath + "_" + (attempt + 1);
                }
                String webDavUrl = this.config.getNodePitUrl() + UrlUtils.urlEncodePathComponents((String)newPath);
                sardine.createDirectory(webDavUrl);
                return new DefaultSpaceItemEnt.DefaultSpaceItemEntBuilder().setId(newPath).setName("Folder").setType(SpaceItemEnt.TypeEnum.WORKFLOWGROUP).build();
            }
            catch (SardineException e) {
                if (attempt >= 25 || e.getStatusCode() != 405) {
                    throw e;
                }
                ++attempt;
                continue;
            }
            break;
        }
    }

    public SpaceItemEnt renameItem(String itemId, String newName) throws IOException, ServiceExceptions.OperationNotAllowedException {
        LOGGER.log("renameItem(%s,%s)", itemId, newName);
        String webDavUrl = this.config.getNodePitUrl() + UrlUtils.urlEncodePathComponents((String)itemId);
        String parentPath = WebDavSpace.getParentPath(itemId);
        String strippedItemId = WebDavFileStore.stripExtension(itemId);
        String extension = itemId.substring(strippedItemId.length());
        String newItemId = parentPath + newName + extension;
        String newWebDavUrl = this.config.getNodePitUrl() + UrlUtils.urlEncodePathComponents((String)newItemId);
        Sardine sardine = this.config.getSardine();
        sardine.move(webDavUrl, newWebDavUrl);
        return new DefaultSpaceItemEnt.DefaultSpaceItemEntBuilder().setId(newItemId).setName(newName).setType(WebDavSpace.mapTypeByExtension(itemId)).build();
    }

    public Optional<Path> toLocalAbsolutePath(ExecutionMonitor monitor, String itemId, VersionId version) throws CanceledExecutionException {
        LOGGER.log("toLocalAbsolutePath(%s,%s)", itemId, version);
        File tempDir = null;
        try {
            tempDir = FileUtil.createTempDir((String)TEMP_PREFIX);
            ExecutorMonitorProgressAdapter progressMonitor = new ExecutorMonitorProgressAdapter(monitor);
            File downloadedFile = this.downloadToFile(itemId, tempDir, progressMonitor);
            Optional<Path> optional = Optional.of(WebDavSpace.unzipWorkflow(downloadedFile));
            return optional;
        }
        catch (IOException e) {
            SardineException sex;
            if (e instanceof SardineException && (sex = (SardineException)((Object)e)).getStatusCode() == 404) {
                Optional<Path> optional = Optional.empty();
                return optional;
            }
            throw new IllegalStateException(e);
        }
        finally {
            if (tempDir != null) {
                FileUtil.deleteRecursively((File)tempDir);
            }
        }
    }

    public LocationInfo getLocationInfo(String itemId, VersionId version) {
        LOGGER.log("getLocationInfo(%s,%s)", itemId, version);
        HubSpaceLocationInfo hubSpaceLocationInfo = ((HubSpaceLocationInfoBuilderFactory.HubSpaceLocationInfoSpaceBuilder)HubSpaceLocationInfoBuilderFactory.create().withRepositoryAddress(URI.create(this.config.getNodePitUrl() + "/space/")).withWorkflowPath("/" + WebDavFileStore.stripExtension(WebDavFileStore.trimSpacePrefix(itemId))).withAuthenticator((Authenticator)new NoOpAuthenticator()).withDefaultMountId(this.mountID)).withSpace(this.type.prefix, this.getId()).withWorkflowItemId("*" + itemId).withItemVersion(Integer.valueOf(1)).build();
        LOGGER.log("getLocationInfo: %s", hubSpaceLocationInfo);
        return hubSpaceLocationInfo;
    }

    public Optional<String> getItemIdByURI(URI uri) {
        LOGGER.log("getItemIdByURI(%s)", uri);
        return Optional.empty();
    }

    public URI toKnimeUrl(String itemId) {
        String uriPath = "knime://" + UrlUtils.urlEncodePathComponents((String)(this.mountID + "/" + WebDavFileStore.trimSpacePrefix(itemId)));
        LOGGER.log("toKnimeUrl(%s): %s", itemId, uriPath);
        return URI.create(uriPath);
    }

    public void deleteItems(List<String> itemIds, boolean softDelete) throws IOException {
        LOGGER.log("deleteItems(%s,%s)", itemIds, softDelete);
        Sardine sardine = this.config.getSardine();
        for (String itemId : itemIds) {
            String webDavUrl = this.config.getNodePitUrl() + UrlUtils.urlEncodePathComponents((String)itemId);
            sardine.delete(webDavUrl);
        }
    }

    public void moveOrCopyItems(List<String> itemIds, String destWorkflowGroupItemId, Space.NameCollisionHandling collisionHandling, boolean copy) throws IOException {
        LOGGER.log("moveOrCopyItems(%s,%s,%s,%s)", itemIds, destWorkflowGroupItemId, collisionHandling, copy);
        for (String itemId : itemIds) {
            this.moveOrCopyItem(itemId, destWorkflowGroupItemId, collisionHandling, copy);
        }
    }

    private void moveOrCopyItem(String itemId, String destWorkflowGroupItemId, Space.NameCollisionHandling collisionHandling, boolean copy) throws IOException {
        String webDavUrl = this.config.getNodePitUrl() + UrlUtils.urlEncodePathComponents((String)itemId);
        itemId = WebDavSpace.trimTrailingSlash(itemId);
        String itemName = itemId.substring(itemId.lastIndexOf("/") + 1);
        String replacedWorkflowGroupItemId = this.replaceRootPlaceholder(destWorkflowGroupItemId);
        Pattern numberSuffixPattern = Pattern.compile(".*_(\\d+)$");
        Matcher startAttemptMatcher = numberSuffixPattern.matcher(itemId);
        int startAttempt = startAttemptMatcher.matches() ? Integer.parseInt(startAttemptMatcher.group(1)) : 0;
        LOGGER.log("moveOrCopyItem - startAttempt: %s", startAttempt);
        int attempt = startAttempt;
        while (true) {
            try {
                String newWebDavUrl = this.config.getNodePitUrl() + UrlUtils.urlEncodePathComponents((String)(replacedWorkflowGroupItemId + itemName));
                if (attempt > 0) {
                    String nameWithoutExtension = WebDavFileStore.stripExtension(newWebDavUrl);
                    String extension = newWebDavUrl.substring(nameWithoutExtension.length());
                    newWebDavUrl = nameWithoutExtension.replaceAll("_\\d+$", "") + "_" + attempt + extension;
                }
                Sardine sardine = this.config.getSardine();
                boolean overwrite = collisionHandling == Space.NameCollisionHandling.OVERWRITE;
                LOGGER.log("moveOrCopyItem - newWebDavUrl: %s", newWebDavUrl);
                LOGGER.log("moveOrCopyItem - overwrite: %s", overwrite);
                if (copy) {
                    sardine.copy(webDavUrl, newWebDavUrl, overwrite);
                } else {
                    sardine.move(webDavUrl, newWebDavUrl, overwrite);
                }
                LOGGER.log("moveOrCopyItem - written: %s", newWebDavUrl);
            }
            catch (SardineException e) {
                block10: {
                    block9: {
                        int statusCode = e.getStatusCode();
                        LOGGER.log("moveOrCopyItem - error status: %s", statusCode);
                        if (statusCode != 403 && statusCode != 412) break block9;
                        if (collisionHandling == Space.NameCollisionHandling.NOOP) break;
                        if (attempt < 25) break block10;
                    }
                    throw e;
                }
                ++attempt;
                continue;
            }
            break;
        }
    }

    public SpaceItemEnt importFile(Path srcPath, String workflowGroupItemId, Space.NameCollisionHandling collisionHandling, IProgressMonitor progressMonitor) throws IOException {
        LOGGER.log("importFile(%s,%s,%s)", srcPath, workflowGroupItemId, collisionHandling);
        return this.importFileOrWorkflow(srcPath, workflowGroupItemId, SpaceItemEnt.TypeEnum.DATA, collisionHandling, progressMonitor);
    }

    public SpaceItemEnt importWorkflowOrWorkflowGroup(Path srcPath, String workflowGroupItemId, Consumer<Path> createMetaInfoFileFor, Space.NameCollisionHandling collisionHandling, IProgressMonitor progressMonitor) throws IOException {
        LOGGER.log("importWorkflowOrWorkflowGroup(%s,%s,%s)", srcPath, workflowGroupItemId, collisionHandling);
        return this.importFileOrWorkflow(srcPath, workflowGroupItemId, SpaceItemEnt.TypeEnum.WORKFLOW, collisionHandling, progressMonitor);
    }

    private DefaultSpaceItemEnt importFileOrWorkflow(Path srcPath, String workflowGroupItemId, SpaceItemEnt.TypeEnum type, Space.NameCollisionHandling collisionHandling, IProgressMonitor progress) throws IOException {
        String fileName = srcPath.getFileName().toString();
        String targetId = this.replaceRootPlaceholder(workflowGroupItemId) + fileName;
        String targetUrl = this.config.getNodePitUrl() + UrlUtils.urlEncodePathComponents((String)targetId);
        Sardine sardine = this.config.getSardine();
        HashMap<String, String> headers = new HashMap<String, String>(Map.of("Expect", "100-continue"));
        if (collisionHandling != Space.NameCollisionHandling.OVERWRITE) {
            headers.put("If-None-Match", "*");
        }
        try {
            Throwable throwable = null;
            Object var12_14 = null;
            try (ProgressMonitorUploadStream inputStream = new ProgressMonitorUploadStream(srcPath.toFile(), progress);){
                sardine.put(targetUrl, (InputStream)inputStream, headers);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SardineException e) {
            if (e.getStatusCode() == 412 && collisionHandling == Space.NameCollisionHandling.NOOP) {
                LOGGER.log("Encountered and ignoring %s due to %s", e.getStatusCode(), collisionHandling);
            }
            throw e;
        }
        return new DefaultSpaceItemEnt.DefaultSpaceItemEntBuilder().setId(targetId).setName(fileName).setType(type).build();
    }

    public List<String> getAncestorItemIds(String itemId) throws ResourceAccessException {
        LOGGER.log("getAncestorItemIds(%s)", itemId);
        String parentPath = WebDavSpace.getParentPath(itemId);
        List<SpacePathSegmentEnt> parentPathList = WebDavSpace.buildPath(parentPath, this.type.prefix);
        return parentPathList.stream().map(SpacePathSegmentEnt::getId).sorted(Comparator.reverseOrder()).toList();
    }

    public Optional<String> getItemIdForName(String workflowGroupItemId, String itemName) throws NoSuchElementException {
        LOGGER.log("getItemIdForName(%s,%s)", workflowGroupItemId, itemName);
        return Optional.empty();
    }

    public String getItemName(String itemId) {
        LOGGER.log("getItemName(%s)", itemId);
        String[] split = itemId.split("/");
        return WebDavFileStore.stripExtension(split[split.length - 1]);
    }

    public SpaceItemEnt.TypeEnum getItemType(String itemId) {
        LOGGER.log("getItemType(%s)", itemId);
        return WebDavSpace.mapTypeByExtension(itemId);
    }

    public Optional<SpaceItemReferenceEnt.ProjectTypeEnum> getProjectType(String itemId) {
        LOGGER.log("getProjectType(%s)", itemId);
        SpaceItemEnt.TypeEnum type = WebDavSpace.mapTypeByExtension(itemId);
        if (type == SpaceItemEnt.TypeEnum.WORKFLOW) {
            return Optional.of(SpaceItemReferenceEnt.ProjectTypeEnum.WORKFLOW);
        }
        if (type == SpaceItemEnt.TypeEnum.COMPONENT) {
            return Optional.of(SpaceItemReferenceEnt.ProjectTypeEnum.COMPONENT);
        }
        return Optional.empty();
    }

    public SpaceEnt toEntity() {
        return EntityFactory.Space.buildSpaceEnt(this.getId(), this.getName(), this.config.getUser(), this.type.description, Boolean.valueOf(this.type.isPrivate));
    }

    public boolean saveBackTo(Path localWorkflow, URI targetURI, boolean excludeDataInWorkflows, IProgressMonitor progressMonitor) throws IOException, UnsupportedOperationException {
        LOGGER.log("saveBackTo(%s,%s,%s)", localWorkflow, targetURI, excludeDataInWorkflows);
        File tempDir = FileUtil.createTempDir((String)TEMP_PREFIX);
        try {
            String workflowFileName = localWorkflow.getFileName().toString() + ".knwf";
            File workflowFile = tempDir.toPath().resolve(workflowFileName).toFile();
            ZipUtil.zipDirectory(localWorkflow.toFile(), workflowFile, true);
            String targetPath = targetURI.getPath().substring(1) + ".knwf";
            String targetUrl = this.config.getNodePitUrl() + UrlUtils.urlEncodePathComponents((String)("/space/" + targetPath));
            Sardine sardine = this.config.getSardine();
            Throwable throwable = null;
            Object var12_13 = null;
            try (ProgressMonitorUploadStream inputStream = new ProgressMonitorUploadStream(workflowFile, progressMonitor);){
                sardine.put(targetUrl, (InputStream)inputStream, null, true);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return true;
        }
        finally {
            FileUtil.deleteRecursively((File)tempDir);
        }
    }

    public SpaceEnt renameSpace(String newName) throws IOException, ServiceExceptions.OperationNotAllowedException {
        throw new ServiceExceptions.OperationNotAllowedException("Renaming of spaces is not allowed.");
    }

    public Optional<URI> getItemUrl(String itemId) throws ResourceAccessException {
        LOGGER.log("getItemUrl(%s)", itemId);
        if (this.type.isPrivate) {
            return Optional.empty();
        }
        String type = itemId.endsWith("/") ? "/server/" : "/workflow/";
        String nodePitId = "com.nodepit.space/" + WebDavFileStore.trimSpacePrefix(itemId).replaceAll("/$", "");
        String url = this.config.getNodePitUrl() + type + UrlUtils.urlEncodePathComponents((String)nodePitId) + "?utm_source=KNIME&utm_medium=Space_Plugin";
        return Optional.of(URI.create(url));
    }

    public Space.TransferResult downloadInto(List<String> itemIds, LocalSpace targetSpace, String targetItemId) throws ServiceExceptions.OperationNotAllowedException {
        LOGGER.log("downloadInto(%s,%s,%s)", itemIds, targetSpace, targetItemId);
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable -> {
                runnable.beginTask(String.format("Downloading %d items \u2026", itemIds.size()), itemIds.size());
                for (String itemId : itemIds) {
                    SubMonitor subtask = SubMonitor.convert((IProgressMonitor)runnable, (int)1);
                    File tempDir = null;
                    try {
                        try {
                            File downloadedFile;
                            tempDir = FileUtil.createTempDir((String)TEMP_PREFIX);
                            if (itemId.endsWith(".knwf")) {
                                downloadedFile = this.downloadToFile(itemId, tempDir, (IProgressMonitor)subtask);
                                Path unzippedWorkflow = WebDavSpace.unzipWorkflow(downloadedFile);
                                FileUtil.zipDir((File)downloadedFile, (File)unzippedWorkflow.toFile(), (int)-1);
                                targetSpace.importWorkflowOrWorkflowGroup(downloadedFile.toPath(), targetItemId, path -> {}, Space.NameCollisionHandling.AUTORENAME, null);
                                continue;
                            }
                            if (itemId.endsWith("/")) {
                                Path destination = (Path)targetSpace.toLocalAbsolutePath(targetItemId).orElseThrow();
                                String trimmedTrailingSlash = WebDavSpace.trimTrailingSlash(itemId);
                                String dirName = trimmedTrailingSlash.substring(trimmedTrailingSlash.lastIndexOf("/") + 1);
                                Path destinationDirPath = destination.resolve(dirName);
                                this.downloadDirectory(itemId, destinationDirPath, (IProgressMonitor)subtask);
                                continue;
                            }
                            downloadedFile = this.downloadToFile(itemId, tempDir, (IProgressMonitor)subtask);
                            targetSpace.importFile(downloadedFile.toPath(), targetItemId, Space.NameCollisionHandling.AUTORENAME, null);
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        if (tempDir != null) {
                            FileUtil.deleteRecursively((File)tempDir);
                        }
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            Throwable cause = e.getCause() != null ? e.getCause() : e;
            return Space.TransferResult.failureWithError((String)"Download failed.", (String)cause.getMessage());
        }
        return Space.TransferResult.SUCCESS;
    }

    private File downloadToFile(String itemId, File tempDir, IProgressMonitor task) throws IOException {
        Sardine sardine = this.config.getSardine();
        String webDavUrl = this.config.getNodePitUrl() + UrlUtils.urlEncodePathComponents((String)itemId);
        String filename = itemId.substring(itemId.lastIndexOf("/"));
        Throwable throwable = null;
        Object var8_9 = null;
        try (ProgressMonitorDownloadStream stream = new ProgressMonitorDownloadStream(sardine.get(webDavUrl), task);){
            File downloadedFile = new File(tempDir, filename);
            Files.copy(stream, downloadedFile.toPath(), new CopyOption[0]);
            return downloadedFile;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void downloadDirectory(String itemId, Path destDir, IProgressMonitor progress) throws IOException {
        LOGGER.log("downloadDirectory(%s,%s)", itemId, destDir);
        Sardine sardine = this.config.getSardine();
        String webDavUrl = this.config.getNodePitUrl() + UrlUtils.urlEncodePathComponents((String)itemId);
        List itemsToDownload = this.config.getSardine().list(webDavUrl, -1);
        SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)progress, (int)itemsToDownload.size());
        for (DavResource item : itemsToDownload) {
            String path = item.getPath();
            String trimmedPath = path.replaceAll("^" + Pattern.quote(itemId), "");
            Path destination = destDir.resolve(WebDavFileStore.stripExtension(trimmedPath));
            if (item.isDirectory()) {
                Files.createDirectories(destination, new FileAttribute[0]);
                continue;
            }
            Throwable throwable = null;
            Object var14_15 = null;
            try (ProgressMonitorDownloadStream download = new ProgressMonitorDownloadStream(sardine.get(item.getHref().toString()), (IProgressMonitor)subProgress.split(1));){
                if (WebDavSpace.isZippedFileType(item.getName())) {
                    FileUtil.unzip((ZipInputStream)new ZipInputStream(download), (File)destination.toFile(), (int)1);
                } else {
                    Files.copy(download, destination, new CopyOption[0]);
                }
                LOGGER.log("downloadDirectory - processed %s", item.getHref());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private static boolean isZippedFileType(String fileName) {
        return Arrays.stream(NodePitConstants.ALL_FILE_EXTENSIONS).anyMatch(ext -> fileName.endsWith((String)ext));
    }

    private String replaceRootPlaceholder(String workflowGroupItemId) {
        Object replacedWorkflowGroupItemId = workflowGroupItemId;
        if ("root".equals(workflowGroupItemId)) {
            replacedWorkflowGroupItemId = "/space/" + this.config.getUser() + this.type.prefix;
        }
        return replacedWorkflowGroupItemId;
    }

    private boolean isIgnored(DavResource file) {
        if (this.type.ignore == null) {
            return false;
        }
        return file.getPath().startsWith("/space/" + this.config.getUser() + this.type.ignore);
    }

    static List<SpacePathSegmentEnt> buildPath(String workflowGroupItemId, String prefix) {
        LOGGER.log("buildPath(%s, %s)", workflowGroupItemId, prefix);
        if ("root".equals(workflowGroupItemId)) {
            return Collections.emptyList();
        }
        String trimmedSpaceUser = WebDavFileStore.trimSpaceAndUserPrefix(workflowGroupItemId);
        String trimmedPrefix = trimmedSpaceUser.replaceAll("^" + Pattern.quote(prefix), "");
        if (trimmedPrefix.isEmpty()) {
            return Collections.emptyList();
        }
        String toKeep = workflowGroupItemId.substring(0, workflowGroupItemId.length() - trimmedPrefix.length());
        ArrayList<SpacePathSegmentEnt> path = new ArrayList<SpacePathSegmentEnt>();
        String[] split = trimmedPrefix.split("/");
        int i = 0;
        while (i < split.length) {
            String id = toKeep + Arrays.asList(split).subList(0, i + 1).stream().collect(Collectors.joining("/")) + "/";
            String name = split[i];
            path.add((SpacePathSegmentEnt)new DefaultSpacePathSegmentEnt(id, name));
            ++i;
        }
        LOGGER.log("buildPath: %s", path);
        return path;
    }

    private static String getParentPath(String url) {
        String parentDir = url;
        if (url.endsWith("/")) {
            parentDir = parentDir.substring(0, parentDir.length() - 1);
        }
        return parentDir.substring(0, parentDir.lastIndexOf("/") + 1);
    }

    private static SpaceItemEnt mapFile(DavResource file) {
        return new DefaultSpaceItemEnt.DefaultSpaceItemEntBuilder().setId(file.getPath()).setName(WebDavFileStore.stripExtension(file.getName())).setType(WebDavSpace.mapType(file)).build();
    }

    private static SpaceItemEnt.TypeEnum mapType(DavResource file) {
        if (file.isDirectory()) {
            return SpaceItemEnt.TypeEnum.WORKFLOWGROUP;
        }
        return WebDavSpace.mapTypeByExtension(file.getName());
    }

    private static SpaceItemEnt.TypeEnum mapTypeByExtension(String filename) {
        if (filename.endsWith(".knwf")) {
            return SpaceItemEnt.TypeEnum.WORKFLOW;
        }
        if (filename.endsWith(".kntp")) {
            return SpaceItemEnt.TypeEnum.COMPONENT;
        }
        return SpaceItemEnt.TypeEnum.DATA;
    }

    private static void createEmptyWorkflow(String name, File destinationFile) throws IOException {
        File tempDirFile = FileUtil.createTempDir((String)TEMP_PREFIX);
        File workflowDir = new File(tempDirFile, name);
        try {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
                    ExecutionMonitor execMonitor = new ExecutionMonitor();
                    WorkflowManager emptyWorkflow = WorkflowManager.ROOT.createAndAddProject(name, new WorkflowCreationHelper(WorkflowContextV2.forTemporaryWorkflow((Path)workflowDir.toPath(), null)));
                    try {
                        emptyWorkflow.save(workflowDir, execMonitor, true);
                    }
                    finally {
                        WorkflowManager.ROOT.removeProject(emptyWorkflow.getID());
                    }
                    ZipUtil.zipDirectory(workflowDir, destinationFile, true);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (CanceledExecutionException | LockFailedException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        finally {
            FileUtil.deleteRecursively((File)tempDirFile);
        }
    }

    private static Path unzipWorkflow(File downloadedFile) throws IOException {
        LOGGER.log("unzipWorkflow(%s)", downloadedFile);
        try {
            String dirName;
            Path renamed;
            File tempDir = FileUtil.createTempDir((String)TEMP_PREFIX);
            FileUtil.unzip((File)downloadedFile, (File)tempDir);
            Object[] files = tempDir.listFiles();
            if (files.length != 1) {
                String msg = String.format("Expected exactly one item in the ZIP archive, but received %s (%s)", files.length, Arrays.toString(files));
                throw new IllegalStateException(msg);
            }
            Path path = files[0].toPath();
            if (!path.equals(renamed = path.resolveSibling(dirName = WebDavFileStore.stripExtension(downloadedFile.getName())))) {
                LOGGER.log("unzipWorkflow: Rename %s to %s", path, renamed);
            }
            Files.move(path, renamed, new CopyOption[0]);
            Path path2 = renamed;
            return path2;
        }
        finally {
            FileUtil.deleteRecursively((File)downloadedFile);
        }
    }

    private static String trimTrailingSlash(String itemId) {
        if (itemId.endsWith("/")) {
            itemId = itemId.substring(0, itemId.length() - 1);
        }
        return itemId;
    }

    static enum Type {
        PUBLIC("/public/", null, "*public", "\ud83c\udf0f Public", false, "This space is shown on nodepit.com and its content can be downloaded by everyone."),
        PRIVATE("/", "/public/", "*private", "\ud83d\udd12 Private", true, "This space can only be accessed by you.");

        private final String prefix;
        private final String ignore;
        private final String id;
        private final String name;
        private final boolean isPrivate;
        private final String description;

        private Type(String prefix, String ignore, String id, String name, boolean isPrivate, String description) {
            this.prefix = Objects.requireNonNull(prefix);
            if (!prefix.startsWith("/")) {
                throw new IllegalArgumentException("prefix must start with /");
            }
            if (!prefix.endsWith("/")) {
                throw new IllegalArgumentException("prefix must end with /");
            }
            if (ignore != null && !ignore.startsWith("/")) {
                throw new IllegalArgumentException("if given ignore must start with /");
            }
            if (ignore != null && !ignore.endsWith("/")) {
                throw new IllegalArgumentException("if given ignore must end with /");
            }
            this.ignore = ignore;
            this.id = Objects.requireNonNull(id);
            if (!id.startsWith("*")) {
                throw new IllegalArgumentException("id must start with *");
            }
            this.name = name;
            this.isPrivate = isPrivate;
            this.description = description;
        }
    }
}

