/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.explorer;

import com.github.sardine.Sardine;
import com.nodepit.knime.explorer.WebDavContentProvider;
import com.nodepit.knime.explorer.WebDavFileStoreConfig;
import com.nodepit.knime.explorer.WebDavFileStoreConfigSource;
import com.nodepit.knime.explorer.WebDavSpace;
import com.nodepit.knime.explorer.utils.Logger;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.knime.gateway.api.webui.entity.SpaceGroupEnt;
import org.knime.gateway.api.webui.entity.SpaceProviderEnt;
import org.knime.gateway.api.webui.util.EntityFactory;
import org.knime.gateway.impl.webui.spaces.Space;
import org.knime.gateway.impl.webui.spaces.SpaceGroup;
import org.knime.gateway.impl.webui.spaces.SpaceProvider;
import org.knime.gateway.impl.webui.spaces.SpaceProviderFactory;
import org.knime.workbench.explorer.ExplorerMountTable;
import org.knime.workbench.explorer.view.AbstractContentProvider;

public class WebDavSpaceProvider
implements SpaceProvider {
    private static final Logger LOGGER = Logger.create(WebDavSpaceProvider.class);
    private final String mountID;
    private final WebDavSpaceGroup spaceGroup = new WebDavSpaceGroup();
    private Consumer<String> loginErrorHandler;
    private NodePitConnection connection;

    WebDavSpaceProvider(String mountID) {
        this.mountID = mountID;
    }

    public void init(Consumer<String> loginErrorHandler) {
        this.loginErrorHandler = loginErrorHandler;
    }

    public String getId() {
        return this.mountID;
    }

    public String getName() {
        return "NodePit";
    }

    public Space getSpace(String spaceId) {
        LOGGER.log("getSpace(%s)", spaceId);
        return this.spaceGroup.getSpaces().stream().filter(space -> space.getId().equals(spaceId)).findFirst().orElseThrow(() -> new NoSuchElementException("No such space: " + spaceId));
    }

    public SpaceGroup<? extends Space> getSpaceGroup(String spaceGroupName) {
        LOGGER.log("getSpaceGroup(%s)", spaceGroupName);
        return this.spaceGroup;
    }

    public List<SpaceGroupEnt> toEntity() {
        return Collections.singletonList(this.spaceGroup.toEntity());
    }

    public SpaceProviderEnt.TypeEnum getType() {
        return SpaceProviderEnt.TypeEnum.HUB;
    }

    public Optional<SpaceProvider.SpaceProviderConnection> getConnection(boolean doConnect) {
        int returnValue;
        LOGGER.log("getConnection(%s)", doConnect);
        if (!doConnect) {
            return Optional.ofNullable(this.connection);
        }
        WebDavFileStoreConfig config = WebDavFileStoreConfigSource.getConfig();
        if (!config.isValidConfig() && (returnValue = WebDavSpaceProvider.openNodePitPreferenceDialog()) == 1) {
            return Optional.empty();
        }
        if (!config.isValidConfig()) {
            this.loginErrorHandler.accept("Invalid configuration");
            return Optional.empty();
        }
        Sardine sardine = config.getSardine();
        try {
            sardine.list(config.getBaseUrl(), 0);
        }
        catch (IOException e) {
            String msg = Optional.ofNullable(e.getMessage()).orElse(e.toString());
            this.loginErrorHandler.accept(msg);
            return Optional.empty();
        }
        this.connection = new NodePitConnection(config);
        return Optional.of(this.connection);
    }

    private static int openNodePitPreferenceDialog() {
        int[] returnValue = new int[1];
        Display.getDefault().syncExec(() -> {
            Shell shell = new Shell(Display.getDefault());
            PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"com.nodepit.knime.preferences", (String[])new String[]{"com.nodepit.knime.preferences"}, null);
            nArray[0] = dialog.open();
        });
        return returnValue[0];
    }

    public static class Factory
    implements SpaceProviderFactory {
        public List<SpaceProvider> createSpaceProviders() {
            Map mountedContent = ExplorerMountTable.getMountedContent();
            Stream<AbstractContentProvider> webDavProviders = mountedContent.values().stream().filter(WebDavContentProvider.class::isInstance);
            return webDavProviders.map(p -> new WebDavSpaceProvider(p.getMountID())).toList();
        }
    }

    class NodePitConnection
    implements SpaceProvider.SpaceProviderConnection {
        private final WebDavFileStoreConfig config;

        public NodePitConnection(WebDavFileStoreConfig config) {
            this.config = config;
        }

        public String getUsername() {
            return this.config.getUser();
        }

        public void disconnect() {
            WebDavSpaceProvider.this.connection = null;
        }
    }

    final class WebDavSpaceGroup
    implements SpaceGroup<Space> {
        WebDavSpaceGroup() {
        }

        public String getName() {
            return WebDavSpaceProvider.this.connection.getUsername();
        }

        public SpaceGroup.SpaceGroupType getType() {
            return SpaceGroup.SpaceGroupType.USER;
        }

        public List<Space> getSpaces() {
            LOGGER.log("getSpaces()", new Object[0]);
            return Arrays.asList(new WebDavSpace(WebDavSpaceProvider.this.mountID, WebDavSpaceProvider.this.connection.config, WebDavSpace.Type.PRIVATE), new WebDavSpace(WebDavSpaceProvider.this.mountID, WebDavSpaceProvider.this.connection.config, WebDavSpace.Type.PUBLIC));
        }

        public SpaceGroupEnt toEntity() {
            return EntityFactory.Space.buildSpaceGroupEnt(this.getName(), this.getName(), this.getType().toEntity(), this.getSpaces().stream().map(Space::toEntity).toList());
        }

        public Space createSpace() throws IOException {
            LOGGER.log("createSpace()", new Object[0]);
            throw new IllegalStateException("Creating new spaces is currently not allowed.");
        }
    }
}

