/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.explorer.jobs;

import com.github.sardine.Sardine;
import com.nodepit.knime.explorer.WebDavFileInfo;
import com.nodepit.knime.explorer.WebDavFileStore;
import com.nodepit.knime.explorer.utils.ProgressMonitorDownloadStream;
import com.nodepit.knime.utils.NodePitConstants;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.knime.core.node.NodeLogger;
import org.knime.core.util.FileUtil;
import org.knime.workbench.explorer.filesystem.AbstractExplorerFileStore;

public class DownloadAndUnzipJob
extends Job {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(DownloadAndUnzipJob.class);
    private final WebDavFileStore source;
    private final Sardine sardine;
    private File downloadResult = null;

    public DownloadAndUnzipJob(WebDavFileStore source, Sardine sardine) {
        super("Download from NodePit");
        this.source = Objects.requireNonNull(source);
        this.sardine = Objects.requireNonNull(sardine);
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            int numItems = DownloadAndUnzipJob.countItems((AbstractExplorerFileStore)this.source);
            File tempDir = Files.createTempDirectory("NodePit_Download", new FileAttribute[0]).toFile();
            LOGGER.debugWithFormat("Downloading to %s", new Object[]{tempDir});
            SubMonitor downloadMonitor = subMonitor.split(75);
            downloadMonitor.beginTask(null, numItems);
            DownloadAndUnzipJob.downloadRecursively(this.source, this.source, tempDir, this.sardine, downloadMonitor);
            File[] filesInTempDir = tempDir.listFiles();
            if (filesInTempDir.length != 1) {
                throw new IllegalStateException();
            }
            SubMonitor unzipMonitor = subMonitor.split(25);
            unzipMonitor.beginTask(null, numItems);
            File unzippedFileResult = DownloadAndUnzipJob.unzipKnwfAndKntp(filesInTempDir[0], (IProgressMonitor)unzipMonitor);
            LOGGER.debugWithFormat("Unzipped all .knwf and .kntp files in %s", new Object[]{unzippedFileResult});
            this.downloadResult = unzippedFileResult;
            return Status.OK_STATUS;
        }
        catch (OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        catch (IOException | CoreException e) {
            return WebDavFileStore.makeStatus("Error while downloading", e);
        }
    }

    private static int countItems(AbstractExplorerFileStore store) throws CoreException {
        int count = 1;
        AbstractExplorerFileStore[] abstractExplorerFileStoreArray = store.childStores(0, (IProgressMonitor)new NullProgressMonitor());
        int n = abstractExplorerFileStoreArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractExplorerFileStore child = abstractExplorerFileStoreArray[n2];
            count += DownloadAndUnzipJob.countItems(child);
            ++n2;
        }
        return count;
    }

    private static void downloadRecursively(WebDavFileStore root, WebDavFileStore source, File tempDir, Sardine sardine, SubMonitor monitor) throws CoreException, IOException {
        block13: {
            LOGGER.debugWithFormat("downloadRecursively(%s,%s,%s)", new Object[]{root, source, tempDir});
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            WebDavFileInfo info = source.fetchInfo();
            String relativeWithRootAndExtension = source.getFullName().replaceAll("^" + Pattern.quote(root.getParent().getFullName()), "") + source.getExtension();
            Path destination = Paths.get(tempDir.getPath(), relativeWithRootAndExtension);
            if (info.isWorkflow() || info.isWorkflowTemplate() || info.isFile()) {
                Throwable throwable = null;
                Object var9_11 = null;
                try (ProgressMonitorDownloadStream is = new ProgressMonitorDownloadStream(sardine.get(source.getWebDavUrl()), (IProgressMonitor)monitor.split(1));){
                    Files.copy(is, destination, new CopyOption[0]);
                    break block13;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            if (info.isDirectory()) {
                AbstractExplorerFileStore[] children;
                destination.toFile().mkdirs();
                monitor.worked(1);
                AbstractExplorerFileStore[] abstractExplorerFileStoreArray = children = source.childStores(0, (IProgressMonitor)new NullProgressMonitor());
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    AbstractExplorerFileStore child = abstractExplorerFileStoreArray[n2];
                    WebDavFileStore remoteChild = (WebDavFileStore)child;
                    DownloadAndUnzipJob.downloadRecursively(root, remoteChild, tempDir, sardine, monitor);
                    ++n2;
                }
            }
        }
    }

    private static File unzipKnwfAndKntp(File file, IProgressMonitor monitor) throws IOException {
        LOGGER.debugWithFormat("unzipKnwfAndKntp(%s", new Object[]{file});
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        File result = file;
        if (DownloadAndUnzipJob.isKntpOrKnwf(file)) {
            File tempDir = Files.createTempDirectory("NodePit_" + file.getName(), new FileAttribute[0]).toFile();
            LOGGER.debugWithFormat("Unzipping %s to %s", new Object[]{file, tempDir});
            FileUtil.unzip((File)file, (File)tempDir);
            File[] files = tempDir.listFiles();
            if (files.length != 1) {
                throw new IllegalStateException(String.format("Expected exactly one subdirectory in %s but got %s.", tempDir, files.length));
            }
            boolean success = file.delete();
            if (!success) {
                throw new IOException("Couldn\u2019t delete " + String.valueOf(file));
            }
            File destination = new File(WebDavFileStore.stripExtension(file.getAbsolutePath()));
            success = files[0].renameTo(destination);
            if (!success) {
                throw new IOException("Couldn\u2019t rename " + String.valueOf(files[0]) + " to " + String.valueOf(destination));
            }
            result = destination;
        } else if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                DownloadAndUnzipJob.unzipKnwfAndKntp(child, monitor);
                ++n2;
            }
        }
        monitor.worked(1);
        return result;
    }

    private static boolean isKntpOrKnwf(File file) {
        if (!file.isFile()) {
            return false;
        }
        String[] stringArray = NodePitConstants.ALL_FILE_EXTENSIONS;
        int n = NodePitConstants.ALL_FILE_EXTENSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            if (file.getName().endsWith(extension)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public File getDownloadResult() {
        return this.downloadResult;
    }
}

