/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.explorer.utils;

import com.github.sardine.impl.io.ContentLengthInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ProgressMonitorDownloadStream
extends InputStream {
    private final InputStream stream;
    private final SubMonitor progressMonitor;

    public ProgressMonitorDownloadStream(InputStream stream, IProgressMonitor progressMonitor) {
        this.stream = Objects.requireNonNull(stream);
        long length = ProgressMonitorDownloadStream.tryGetLength(stream);
        this.progressMonitor = SubMonitor.convert((IProgressMonitor)Objects.requireNonNull(progressMonitor), (int)((int)length));
    }

    private static long tryGetLength(InputStream stream) {
        long length = -1L;
        if (stream instanceof ContentLengthInputStream) {
            length = Optional.ofNullable(((ContentLengthInputStream)stream).getLength()).orElse(-1L);
        }
        return length;
    }

    @Override
    public int read() throws IOException {
        this.checkCanceled();
        try {
            int n = this.stream.read();
            return n;
        }
        finally {
            this.progressMonitor.worked(1);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkCanceled();
        int numBytes = this.stream.read(b, off, len);
        this.progressMonitor.worked(numBytes);
        return numBytes;
    }

    @Override
    public void close() throws IOException {
        try {
            this.stream.close();
        }
        finally {
            this.progressMonitor.done();
        }
    }

    private void checkCanceled() throws IOException {
        if (this.progressMonitor.isCanceled()) {
            throw new IOException("Download was canceled.");
        }
    }
}

