/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.explorer.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public final class ProgressMonitorUploadStream
extends InputStream {
    private final FileInputStream wrappedStream;
    private final SubMonitor progressMonitor;

    public ProgressMonitorUploadStream(File file, IProgressMonitor progressMonitor) throws FileNotFoundException {
        this.wrappedStream = new FileInputStream(Objects.requireNonNull(file));
        this.progressMonitor = SubMonitor.convert((IProgressMonitor)Objects.requireNonNull(progressMonitor), (int)((int)file.length()));
    }

    @Override
    public int read() throws IOException {
        this.checkCanceled();
        try {
            int n = this.wrappedStream.read();
            return n;
        }
        finally {
            this.progressMonitor.worked(1);
        }
    }

    private void checkCanceled() throws IOException {
        if (this.progressMonitor.isCanceled()) {
            throw new IOException("Upload was canceled.");
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkCanceled();
        int numBytes = this.wrappedStream.read(b, off, len);
        this.progressMonitor.worked(numBytes);
        return numBytes;
    }

    @Override
    public void close() throws IOException {
        try {
            this.wrappedStream.close();
        }
        finally {
            this.progressMonitor.done();
        }
    }

    @Override
    public int available() throws IOException {
        return this.wrappedStream.available();
    }
}

